//
// Title:	        Pico-mposite Demonstration Bitmap
// Author:	        Dean Belfield
// Created:	        12/02/2021
// Last Updated:	01/03/2022
//
// Description:
//
// The monochrome bitmap an array of pixels, where each pixel is a value between 0x10 and 0x1F, giving 16 shades of 
// grey between 0x10 (black) and 0x1F (white). The values correspond to a 5-bit pattern which is converted by the resistor 
// ladder on the Pico GPIO to a voltage output on the composite output of between ~0.5V and 1V
//
// The colour bitmap is an array of pixels, where each pixel is an RGB value, with the bits being arranged as RRRGGGBB
//
// Modinfo:
// 01/02/2022:      Renamed sample_bitmap, made a const, moved to bitmap.c
// 08/02/2022:      Added colour bitmap
// 20/02/2022:      Removed reference to graphics.h
// 01/03/2022:      Fixed colour bitmap

#include "bitmap.h"

#if opt_colour == 0 

unsigned char const sample_bitmap[192][256] = {
    {0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x18},
    {0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x17},
    {0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
    {0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x1A,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17},
    {0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x1A,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17},
    {0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x19,0x19,0x1A,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
    {0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18},
    {0x1C,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17},
    {0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x18,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
    {0x1D,0x1C,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
    {0x1D,0x1D,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1C,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
    {0x1D,0x1D,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18},
    {0x1D,0x1D,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17},
    {0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17},
    {0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17},
    {0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x18,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x17},
    {0x1D,0x1D,0x1D,0x1D,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17},
    {0x1D,0x1D,0x1D,0x1D,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1E,0x1D,0x1D,0x1E,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17},
    {0x1D,0x1D,0x1D,0x1D,0x1C,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1C,0x1D,0x1D,0x1E,0x1E,0x1D,0x1E,0x1F,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18},
    {0x1D,0x1D,0x1D,0x1D,0x1C,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1D,0x1E,0x1E,0x1E,0x1D,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x18},
    {0x1D,0x1D,0x1D,0x1D,0x1C,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x18,0x19,0x19,0x1A,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17},
    {0x1D,0x1D,0x1D,0x1D,0x1C,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1C,0x1C,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1E,0x1F,0x1E,0x1E,0x1D,0x1D,0x1E,0x1D,0x1C,0x1C,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x17},
    {0x1D,0x1D,0x1D,0x1D,0x1C,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1E,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x1A,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x18,0x18},
    {0x1D,0x1D,0x1D,0x1D,0x1C,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1E,0x1E,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1E,0x1E,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x1A,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17},
    {0x1D,0x1D,0x1D,0x1D,0x1C,0x1A,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1E,0x1E,0x1F,0x1E,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1E,0x1D,0x1D,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x18,0x19,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17},
    {0x1E,0x1D,0x1D,0x1D,0x1C,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1E,0x1D,0x1D,0x1E,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1E,0x1D,0x1D,0x1D,0x1C,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1E,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x17,0x17},
    {0x1E,0x1D,0x1D,0x1D,0x1C,0x1A,0x19,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1F,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1E,0x1D,0x1E,0x1E,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1E,0x1E,0x1D,0x1D,0x1B,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1E,0x1F,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1E,0x1E,0x1D,0x1D,0x1B,0x19,0x1A,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1A,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1E,0x1E,0x1E,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1E,0x1D,0x1D,0x1E,0x1E,0x1F,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1E,0x1E,0x1E,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x18,0x18,0x19,0x18,0x17,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1E,0x1D,0x1D,0x1D,0x1B,0x1A,0x1A,0x19,0x18,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1A,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1C,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1F,0x1E,0x1E,0x1D,0x1D,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x17,0x17,0x17},
    {0x1E,0x1D,0x1D,0x1C,0x1B,0x1A,0x1A,0x19,0x18,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1A,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x17,0x18,0x18,0x17,0x17},
    {0x1D,0x1D,0x1D,0x1D,0x1B,0x1B,0x1B,0x1A,0x19,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x17,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17},
    {0x1D,0x1D,0x1D,0x1C,0x1B,0x1C,0x1C,0x1B,0x19,0x1C,0x1B,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x18,0x17,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1E,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1F,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1D,0x1D,0x1C,0x1B,0x1A,0x1C,0x1E,0x1D,0x1A,0x1C,0x1B,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1D,0x1C,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1C,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1D,0x1D,0x1C,0x1A,0x19,0x1B,0x1D,0x1C,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x19,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1F,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1D,0x1D,0x1B,0x19,0x19,0x1A,0x1C,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1D,0x1C,0x1A,0x18,0x19,0x19,0x1A,0x19,0x19,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1E,0x1F,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1E,0x1F,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1D,0x1C,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1C,0x1C,0x1D,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1D,0x1A,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x18,0x17,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1C,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1C,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1A,0x17,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17},
    {0x1B,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x17,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x19,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1D,0x1E,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x19,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x18,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1E,0x1E,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x19,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x17},
    {0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1D,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x17,0x17,0x17,0x17,0x17,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x17,0x17,0x17,0x17,0x18,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x18,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x17,0x17,0x16,0x17,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x17,0x17,0x17,0x18,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1A,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x16,0x17,0x16,0x17,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1D,0x1B,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x16,0x16,0x17,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1D,0x1B,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x16,0x16,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1D,0x1B,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x18,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x16,0x17,0x19,0x19,0x1A,0x1A,0x1B,0x1D,0x1B,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x18,0x17,0x17,0x17,0x17,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1D,0x1A,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x18,0x19,0x19,0x1A,0x1B,0x1A,0x1B,0x19,0x1C,0x18,0x17,0x17,0x19,0x1C,0x1B,0x17,0x17,0x18,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1A,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17},
    {0x18,0x19,0x19,0x1A,0x1B,0x1C,0x1A,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1B,0x17,0x19,0x17,0x17,0x16,0x19,0x1C,0x19,0x19,0x18,0x16,0x16,0x17,0x17,0x17,0x17,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x17,0x17},
    {0x19,0x19,0x1A,0x1B,0x1C,0x1A,0x18,0x18,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x1A,0x19,0x1A,0x17,0x17,0x16,0x16,0x17,0x1A,0x1D,0x18,0x1C,0x18,0x17,0x16,0x17,0x17,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x1A,0x1A,0x19,0x18,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x19,0x19,0x1B,0x1B,0x19,0x18,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x1A,0x17,0x17,0x16,0x16,0x17,0x1A,0x1C,0x17,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x1D,0x19,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x19,0x1A,0x1A,0x18,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x18,0x1A,0x1B,0x17,0x16,0x16,0x17,0x18,0x19,0x17,0x16,0x16,0x16,0x16,0x18,0x18,0x17,0x1A,0x18,0x17,0x16,0x16,0x19,0x17,0x18,0x17,0x16,0x18,0x18,0x17,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x19,0x18,0x18,0x19,0x19,0x17,0x16,0x16,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x18,0x16,0x16,0x16,0x16,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x1C,0x17,0x16,0x16,0x17,0x17,0x19,0x17,0x16,0x17,0x18,0x18,0x18,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x18,0x19,0x19,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x18,0x18,0x1A,0x18,0x19,0x17,0x16,0x16,0x19,0x1C,0x1B,0x17,0x17,0x16,0x18,0x1C,0x18,0x16,0x16,0x17,0x16,0x16,0x17,0x18,0x16,0x16,0x16,0x17,0x16,0x17,0x1C,0x1A,0x1B,0x17,0x17,0x17,0x18,0x18,0x19,0x18,0x18,0x19,0x1C,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x19,0x19,0x18,0x17,0x16,0x16,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x1A,0x1C,0x18,0x17,0x17,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x17,0x16,0x16,0x16,0x16,0x17,0x19,0x16,0x16,0x16,0x16,0x16,0x19,0x1D,0x18,0x17,0x17,0x18,0x16,0x17,0x19,0x19,0x19,0x17,0x18,0x1D,0x19,0x17,0x18,0x19,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16},
    {0x19,0x18,0x17,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1A,0x19,0x1A,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x1A,0x19,0x18,0x1A,0x1A,0x19,0x1B,0x1C,0x1C,0x19,0x1A,0x1C,0x1A,0x18,0x18,0x19,0x1C,0x1B,0x17,0x16,0x16,0x16,0x16,0x1B,0x1C,0x17,0x16,0x16,0x16,0x16,0x19,0x1C,0x1A,0x1A,0x17,0x17,0x19,0x19,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x18,0x16,0x15,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x19,0x1A,0x19,0x18,0x17,0x18,0x1B,0x1A,0x19,0x1C,0x1C,0x1B,0x19,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1B,0x19,0x19,0x18,0x18,0x1C,0x1B,0x17,0x16,0x16,0x16,0x16,0x1A,0x1B,0x16,0x16,0x16,0x17,0x1B,0x1A,0x17,0x1C,0x17,0x17,0x16,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17},
    {0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x18,0x18,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x18,0x17,0x1A,0x1B,0x1A,0x1A,0x1B,0x1D,0x1A,0x1A,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x19,0x1A,0x1C,0x1A,0x17,0x16,0x16,0x18,0x1C,0x1A,0x16,0x16,0x16,0x16,0x1A,0x18,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x17},
    {0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x18,0x18,0x19,0x19,0x1A,0x1B,0x1B,0x19,0x18,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1A,0x19,0x1B,0x1D,0x1C,0x1C,0x1A,0x19,0x1C,0x1C,0x17,0x16,0x16,0x17,0x1C,0x19,0x16,0x16,0x16,0x16,0x16,0x19,0x18,0x18,0x19,0x18,0x18,0x17,0x18,0x16,0x18,0x18,0x17,0x16,0x17,0x17,0x17,0x17,0x18,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x16},
    {0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x19,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x18,0x18,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1A,0x19,0x19,0x1C,0x1C,0x1D,0x1C,0x19,0x1A,0x1C,0x1C,0x1B,0x1A,0x19,0x1A,0x19,0x16,0x16,0x16,0x16,0x16,0x19,0x17,0x17,0x17,0x17,0x17,0x17,0x1A,0x17,0x1B,0x17,0x16,0x16,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x19,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x1A,0x19,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x16,0x16},
    {0x16,0x16,0x16,0x17,0x17,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1C,0x1B,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x1B,0x1B,0x1B,0x1C,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1C,0x19,0x1A,0x1C,0x1C,0x1B,0x1A,0x19,0x1B,0x1D,0x1C,0x1B,0x19,0x19,0x1B,0x17,0x16,0x16,0x18,0x1A,0x1C,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x1B,0x18,0x1A,0x16,0x18,0x18,0x19,0x19,0x18,0x17,0x17,0x17,0x19,0x18,0x19,0x18,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x18,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16},
    {0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1C,0x1C,0x1A,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x1B,0x1B,0x1C,0x1B,0x1B,0x1C,0x1B,0x1A,0x1A,0x19,0x19,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1B,0x19,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x17,0x17,0x19,0x1B,0x1A,0x1A,0x17,0x17,0x17,0x17,0x1A,0x19,0x16,0x16,0x16,0x16,0x16,0x17,0x19,0x16,0x16,0x16,0x18,0x19,0x1A,0x1A,0x1C,0x1C,0x17,0x16,0x17,0x1B,0x1B,0x17,0x18,0x17,0x1B,0x19,0x18,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x18,0x18,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x19,0x19,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1C,0x1B,0x1A,0x1B,0x19,0x19,0x19,0x19,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x1A,0x19,0x19,0x19,0x18,0x19,0x1A,0x1D,0x1A,0x17,0x16,0x16,0x16,0x17,0x1B,0x1B,0x16,0x16,0x16,0x16,0x1B,0x1C,0x1A,0x17,0x19,0x17,0x17,0x17,0x1C,0x1B,0x1C,0x18,0x17,0x16,0x19,0x17,0x16,0x17,0x17,0x17,0x16,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1D,0x1D,0x1C,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x1A,0x19,0x1B,0x1D,0x1B,0x19,0x19,0x1A,0x1B,0x1C,0x1C,0x17,0x16,0x16,0x16,0x1B,0x1D,0x19,0x16,0x16,0x16,0x16,0x19,0x1C,0x1A,0x1A,0x17,0x17,0x18,0x19,0x17,0x18,0x19,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x19,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x17},
    {0x16,0x17,0x17,0x17,0x16,0x16,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1A,0x1B,0x1B,0x1F,0x1F,0x1E,0x1D,0x1C,0x1A,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x1C,0x1D,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1A,0x1B,0x19,0x1B,0x1D,0x1A,0x1A,0x16,0x16,0x16,0x16,0x1C,0x1D,0x18,0x16,0x16,0x16,0x19,0x19,0x17,0x19,0x1A,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x19,0x1A,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17},
    {0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1E,0x1D,0x17,0x19,0x1E,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1C,0x1B,0x1B,0x1B,0x1C,0x1C,0x19,0x19,0x1B,0x1C,0x1B,0x1A,0x1A,0x1B,0x17,0x16,0x17,0x1A,0x1D,0x1C,0x18,0x16,0x16,0x16,0x1B,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x19,0x1C,0x1A,0x16,0x16,0x18,0x18,0x16,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1E,0x1E,0x1C,0x19,0x1A,0x1D,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x19,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1A,0x1A,0x1B,0x1C,0x1C,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x18,0x18,0x19,0x1B,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x19,0x17,0x16,0x16,0x16,0x17,0x1B,0x1A,0x17,0x1D,0x18,0x16,0x16,0x17,0x17,0x16,0x17,0x17,0x16,0x16,0x17,0x17,0x19,0x1A,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x1D,0x1D,0x1E,0x1A,0x1B,0x1C,0x1C,0x1C,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1D,0x1C,0x1A,0x1B,0x1C,0x1C,0x1B,0x1A,0x19,0x19,0x19,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1C,0x1B,0x1A,0x1C,0x1C,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x1A,0x1B,0x1C,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x1C,0x17,0x16,0x16,0x16,0x17,0x1C,0x1A,0x16,0x18,0x16,0x16,0x16,0x17,0x18,0x16,0x1C,0x18,0x16,0x16,0x17,0x17,0x16,0x16,0x17,0x17,0x1A,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1A,0x1B,0x19,0x1B,0x1C,0x1C,0x1B,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x1A,0x19,0x16,0x16,0x16,0x16,0x16,0x1B,0x1A,0x19,0x16,0x16,0x16,0x1A,0x1C,0x1A,0x16,0x16,0x16,0x16,0x16,0x18,0x17,0x17,0x1A,0x16,0x16,0x16,0x16,0x18,0x18,0x1A,0x17,0x16,0x18,0x1A,0x1A,0x18,0x17,0x18,0x17,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1B,0x1A,0x1A,0x1B,0x1C,0x19,0x19,0x1B,0x1C,0x1C,0x1C,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1C,0x1C,0x1C,0x1C,0x1C,0x19,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x18,0x1A,0x1B,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x1A,0x1B,0x1B,0x19,0x1A,0x1A,0x1B,0x1C,0x1C,0x1A,0x17,0x16,0x16,0x16,0x17,0x1C,0x17,0x16,0x16,0x16,0x16,0x16,0x1A,0x19,0x19,0x18,0x17,0x17,0x1A,0x1B,0x18,0x17,0x19,0x18,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x17,0x17,0x16},
    {0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1D,0x1F,0x1E,0x1D,0x1C,0x1A,0x19,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x19,0x1A,0x1A,0x1C,0x1C,0x1C,0x1C,0x19,0x1B,0x1A,0x1A,0x1B,0x1C,0x1A,0x1A,0x1B,0x1A,0x1A,0x1C,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x17,0x17,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1B,0x1C,0x1A,0x19,0x19,0x19,0x17,0x16,0x17,0x1A,0x1C,0x17,0x16,0x16,0x16,0x16,0x17,0x1D,0x18,0x16,0x16,0x16,0x17,0x1B,0x1D,0x1B,0x19,0x1C,0x17,0x16,0x16,0x17,0x17,0x16,0x1A,0x18,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x17,0x17,0x17},
    {0x17,0x18,0x18,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1E,0x1F,0x1D,0x1B,0x1E,0x1E,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x1A,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1E,0x1E,0x1E,0x1F,0x1D,0x19,0x1B,0x1C,0x1C,0x1C,0x1D,0x1A,0x1A,0x1B,0x1C,0x1B,0x1C,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x19,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x17,0x16,0x16,0x17,0x1C,0x1D,0x19,0x17,0x17,0x17,0x17,0x1C,0x1C,0x19,0x16,0x16,0x16,0x16,0x16,0x18,0x18,0x18,0x1D,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x17,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x18,0x17,0x18,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1E,0x1E,0x18,0x1A,0x1C,0x1E,0x1B,0x1A,0x1B,0x1A,0x1A,0x18,0x19,0x1A,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x17,0x1B,0x1C,0x1C,0x1D,0x1D,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1A,0x1C,0x1C,0x1B,0x1B,0x19,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1A,0x1A,0x19,0x1B,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x1C,0x1C,0x1A,0x19,0x1C,0x1C,0x1A,0x1A,0x18,0x17,0x17,0x19,0x1C,0x1B,0x1B,0x17,0x16,0x16,0x16,0x16,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x19,0x16,0x1C,0x1B,0x17,0x16,0x17,0x17,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x18,0x18,0x18,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1D,0x1F,0x1F,0x1E,0x19,0x1A,0x1D,0x1D,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1A,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1E,0x1E,0x1E,0x1F,0x1F,0x1D,0x18,0x1B,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1B,0x1C,0x1B,0x1C,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x19,0x1A,0x1B,0x19,0x19,0x1B,0x19,0x19,0x1A,0x1C,0x1A,0x19,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x1B,0x1A,0x1A,0x1D,0x1D,0x1D,0x1C,0x1A,0x1A,0x19,0x1C,0x1C,0x1B,0x19,0x1A,0x1B,0x1B,0x1C,0x1E,0x1D,0x18,0x16,0x16,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x19,0x18,0x16,0x16,0x17,0x17,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x16},
    {0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1D,0x1E,0x1E,0x1F,0x1C,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x1B,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1E,0x1E,0x1E,0x1F,0x1E,0x1C,0x18,0x1C,0x1C,0x1C,0x1B,0x19,0x1C,0x1B,0x1C,0x1C,0x18,0x16,0x16,0x18,0x19,0x1A,0x1A,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1C,0x1B,0x18,0x1B,0x1C,0x1B,0x19,0x1A,0x1B,0x19,0x19,0x18,0x19,0x19,0x1B,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1D,0x1C,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x19,0x17,0x16,0x16,0x16,0x16,0x16,0x19,0x18,0x16,0x16,0x17,0x16,0x16,0x18,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x17,0x17},
    {0x18,0x18,0x18,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1C,0x1C,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1E,0x1F,0x1E,0x1F,0x1E,0x1A,0x18,0x19,0x19,0x19,0x19,0x19,0x1B,0x1B,0x1B,0x1B,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x19,0x1A,0x1A,0x19,0x18,0x1A,0x19,0x18,0x18,0x18,0x18,0x1A,0x19,0x18,0x17,0x18,0x19,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1A,0x1C,0x1B,0x1A,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x1B,0x1A,0x17,0x16,0x16,0x17,0x19,0x1A,0x19,0x16,0x16,0x16,0x16,0x17,0x18,0x17,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16},
    {0x19,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1D,0x1C,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x19,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1E,0x1E,0x1E,0x1F,0x1E,0x17,0x1C,0x1A,0x1B,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x19,0x1A,0x1B,0x1C,0x1C,0x18,0x19,0x19,0x1A,0x1A,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1B,0x1C,0x1A,0x1B,0x1B,0x1A,0x19,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1B,0x19,0x1B,0x19,0x1A,0x1A,0x1B,0x19,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1A,0x1A,0x19,0x1B,0x1A,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x19,0x1B,0x1A,0x18,0x17,0x1A,0x1A,0x17,0x17,0x19,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16},
    {0x1A,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x1A,0x1E,0x1F,0x1F,0x1E,0x1C,0x1A,0x1C,0x1C,0x1C,0x1B,0x1A,0x19,0x19,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1A,0x1A,0x1B,0x1D,0x1D,0x1D,0x1C,0x18,0x1C,0x19,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x19,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x16,0x19,0x1B,0x1A,0x1A,0x1A,0x19,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x19,0x1A,0x1C,0x1C,0x1E,0x1F,0x1E,0x1D,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x19,0x1B,0x1A,0x1B,0x1C,0x17,0x16,0x16,0x17,0x1B,0x1A,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1B,0x1C,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x18,0x17,0x17,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16},
    {0x19,0x1A,0x1A,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x19,0x1D,0x1F,0x1B,0x18,0x1C,0x1D,0x1B,0x1C,0x1C,0x1B,0x1B,0x1A,0x19,0x1A,0x1C,0x1B,0x1C,0x1D,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x19,0x16,0x16,0x17,0x16,0x18,0x18,0x18,0x1A,0x19,0x18,0x1B,0x19,0x1A,0x19,0x19,0x1A,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x1A,0x1B,0x1B,0x1A,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x19,0x1A,0x17,0x18,0x1C,0x1C,0x1C,0x1B,0x1D,0x1C,0x1E,0x1E,0x1C,0x1D,0x1D,0x1E,0x1F,0x1E,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x19,0x1A,0x1F,0x1E,0x18,0x18,0x1B,0x1C,0x1C,0x1B,0x1C,0x1B,0x1C,0x1D,0x1C,0x1B,0x18,0x17,0x17,0x17,0x17,0x1A,0x1C,0x1C,0x17,0x17,0x18,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x19,0x19,0x1A,0x1A,0x19,0x18,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1C,0x1F,0x1E,0x18,0x1A,0x1B,0x1E,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x19,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1A,0x1B,0x1B,0x18,0x17,0x1B,0x19,0x18,0x1B,0x19,0x18,0x1A,0x19,0x19,0x19,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x1A,0x1C,0x1C,0x1B,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x19,0x19,0x1B,0x1A,0x1C,0x1C,0x1C,0x1B,0x1E,0x1F,0x1D,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1E,0x1D,0x1B,0x19,0x1D,0x1D,0x1D,0x1C,0x17,0x1D,0x1F,0x1F,0x1B,0x19,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1A,0x1C,0x1B,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x19,0x1B,0x17,0x17,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x19,0x19,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x1C,0x1E,0x1F,0x1F,0x1D,0x1C,0x1E,0x1C,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x1A,0x19,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1A,0x1C,0x1A,0x1B,0x1B,0x18,0x19,0x1C,0x1D,0x1D,0x1A,0x1A,0x19,0x19,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x1B,0x1A,0x1B,0x1A,0x17,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x19,0x19,0x19,0x1B,0x1C,0x1D,0x1D,0x1C,0x1D,0x1E,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1E,0x1B,0x18,0x1B,0x1B,0x1D,0x1D,0x19,0x18,0x1D,0x1D,0x17,0x1A,0x1C,0x1C,0x1C,0x1C,0x1E,0x1C,0x1A,0x1C,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x1A,0x19,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x18,0x18,0x18,0x18,0x18,0x1A,0x1B,0x1C,0x1D,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x19,0x1A,0x19,0x19,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1A,0x1B,0x19,0x18,0x1C,0x1D,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x15,0x16,0x18,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1C,0x1E,0x1D,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1E,0x1D,0x18,0x1C,0x1D,0x1D,0x1D,0x1C,0x18,0x17,0x17,0x19,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1A,0x1B,0x1A,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x19,0x1B,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1B,0x1B,0x1B,0x1A,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x19,0x19,0x19,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1C,0x1C,0x1C,0x1C,0x1C,0x19,0x1A,0x19,0x1A,0x1B,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1C,0x1B,0x1C,0x1B,0x1B,0x1C,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1A,0x1B,0x1C,0x1D,0x1C,0x1C,0x1C,0x1D,0x1B,0x1B,0x19,0x18,0x18,0x1B,0x1A,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x18,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1E,0x1E,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x19,0x1E,0x1C,0x17,0x1A,0x1B,0x1C,0x1A,0x1A,0x1B,0x1B,0x1C,0x1D,0x1D,0x1C,0x1B,0x1B,0x1C,0x1B,0x1A,0x1D,0x19,0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x18,0x17,0x18,0x1B,0x16,0x17,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1B,0x1B,0x1B,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x19,0x19,0x19,0x1B,0x1C,0x1C,0x1D,0x1C,0x1B,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x19,0x1B,0x1C,0x1B,0x1A,0x1A,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x19,0x19,0x19,0x19,0x1C,0x1C,0x1B,0x1A,0x19,0x18,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1C,0x1D,0x1D,0x1C,0x1C,0x1A,0x1C,0x1E,0x1B,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x1F,0x1A,0x17,0x1A,0x1A,0x1A,0x1C,0x1C,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x18,0x17,0x1A,0x1A,0x1A,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x19,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x19,0x1A,0x1B,0x1B,0x1A,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x19,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1A,0x1A,0x19,0x1A,0x1C,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1B,0x1B,0x1C,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x19,0x1A,0x19,0x19,0x18,0x18,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x16,0x16,0x16,0x16,0x16,0x17,0x19,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1C,0x1D,0x1D,0x1C,0x1C,0x1B,0x1D,0x1B,0x1D,0x1F,0x1C,0x1A,0x18,0x18,0x18,0x19,0x1D,0x1E,0x18,0x17,0x1A,0x19,0x1C,0x1D,0x1C,0x18,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1B,0x1C,0x1A,0x17,0x17,0x17,0x16,0x16,0x16,0x17,0x18,0x17,0x1B,0x18,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x18,0x17,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x19,0x19,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x18,0x18,0x18,0x19,0x1A,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x19,0x1A,0x19,0x1B,0x1A,0x1C,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x19,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x16,0x16,0x16,0x15,0x17,0x19,0x1B,0x19,0x19,0x19,0x1B,0x1C,0x1C,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1C,0x1C,0x1D,0x1C,0x1B,0x1B,0x1A,0x1B,0x17,0x18,0x1C,0x1D,0x1F,0x1F,0x1E,0x1E,0x1E,0x1C,0x1B,0x18,0x18,0x1A,0x1B,0x1D,0x1D,0x1B,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1C,0x1B,0x1C,0x1B,0x1B,0x1A,0x19,0x18,0x17,0x17,0x17,0x18,0x18,0x18,0x1A,0x1C,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1B,0x1A,0x19,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x1A,0x19,0x18,0x18,0x19,0x19,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x18,0x17,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1B,0x1C,0x1C,0x1D,0x1C,0x1B,0x1B,0x1A,0x19,0x1A,0x19,0x1A,0x1C,0x1C,0x18,0x16,0x16,0x16,0x17,0x18,0x1A,0x1C,0x1B,0x1A,0x19,0x18,0x1D,0x1A,0x1A,0x1B,0x1D,0x1B,0x1A,0x1C,0x1A,0x1A,0x1C,0x1C,0x1C,0x1F,0x1E,0x1B,0x1B,0x1C,0x1D,0x1D,0x1C,0x1C,0x1B,0x1A,0x19,0x18,0x1A,0x1D,0x1B,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x1B,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x1A,0x1A,0x1A,0x1A,0x1A,0x18,0x18,0x19,0x19,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x19,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x19,0x19,0x1A,0x18,0x18,0x19,0x19,0x1A,0x1C,0x1C,0x1B,0x1A,0x1A,0x1B,0x1C,0x1C,0x1D,0x1C,0x1C,0x1B,0x1B,0x1A,0x19,0x19,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x1E,0x1C,0x1B,0x1A,0x1C,0x19,0x1B,0x1C,0x1B,0x19,0x1D,0x1D,0x1C,0x1F,0x1E,0x18,0x17,0x18,0x1B,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1B,0x1A,0x18,0x1A,0x19,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x17,0x17},
    {0x1A,0x1B,0x1B,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x18,0x17,0x1A,0x1A,0x1C,0x1C,0x19,0x16,0x16,0x17,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x1C,0x19,0x1A,0x19,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x1A,0x1B,0x1A,0x1B,0x1A,0x18,0x1A,0x1C,0x1C,0x1A,0x1A,0x1B,0x1B,0x1A,0x19,0x19,0x1B,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1C,0x1B,0x1A,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x1A,0x1C,0x1D,0x1A,0x19,0x19,0x1B,0x1B,0x1A,0x1A,0x1B,0x1D,0x1D,0x1D,0x1C,0x17,0x17,0x19,0x1B,0x1D,0x1D,0x1D,0x1C,0x1B,0x1C,0x1C,0x1D,0x1D,0x1E,0x1C,0x18,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x18,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1B,0x1B,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x18,0x18,0x18,0x19,0x1B,0x1A,0x1A,0x1A,0x19,0x17,0x18,0x1B,0x1B,0x1B,0x1A,0x16,0x1B,0x1C,0x18,0x17,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1C,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1A,0x19,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x18,0x19,0x1A,0x19,0x17,0x18,0x1B,0x1B,0x1A,0x19,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x19,0x19,0x1B,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1C,0x1B,0x1A,0x19,0x18,0x17,0x18,0x1B,0x1C,0x1D,0x1D,0x1A,0x18,0x1B,0x19,0x16,0x19,0x19,0x1C,0x1D,0x1A,0x19,0x18,0x18,0x19,0x1D,0x1D,0x1D,0x1D,0x19,0x19,0x19,0x19,0x19,0x1D,0x1E,0x1C,0x1B,0x17,0x16,0x16,0x17,0x17,0x18,0x18,0x17,0x18,0x18,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x18,0x19,0x19,0x18,0x18,0x19,0x1A,0x1A,0x18,0x18,0x18,0x1B,0x1C,0x1C,0x1C,0x18,0x1B,0x1F,0x1F,0x1C,0x16,0x1A,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1C,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x19,0x1B,0x1C,0x1B,0x19,0x1A,0x1B,0x1B,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x18,0x1A,0x1B,0x1A,0x1B,0x1B,0x19,0x1A,0x1B,0x1C,0x1C,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1C,0x1D,0x1D,0x1D,0x1C,0x1B,0x1B,0x1B,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x1B,0x1E,0x1C,0x1A,0x1A,0x18,0x1A,0x1E,0x1D,0x1D,0x1D,0x1A,0x18,0x18,0x18,0x19,0x1C,0x1D,0x1B,0x1B,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x19,0x18,0x1A,0x1D,0x1A,0x18,0x18,0x18,0x18,0x18,0x18,0x1B,0x1C,0x1C,0x1B,0x1B,0x18,0x19,0x1F,0x1F,0x1A,0x18,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1C,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x19,0x1A,0x1A,0x19,0x18,0x1A,0x1C,0x1C,0x1C,0x1B,0x19,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1C,0x1B,0x1B,0x1B,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1B,0x1B,0x1A,0x1A,0x1C,0x1C,0x19,0x1B,0x1C,0x1C,0x1B,0x1C,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1C,0x19,0x1B,0x1D,0x1D,0x1B,0x1B,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16},
    {0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x1A,0x1B,0x1A,0x1A,0x1B,0x1C,0x1A,0x19,0x1A,0x1B,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x16,0x17,0x17,0x17,0x1C,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1C,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x1B,0x1A,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1C,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x19,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1C,0x1B,0x1A,0x17,0x17,0x17,0x17,0x17,0x18,0x19,0x19,0x18,0x19,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x1B,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1D,0x19,0x1B,0x18,0x17,0x18,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1C,0x1B,0x1B,0x1B,0x1A,0x1C,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1A,0x1A,0x1B,0x1C,0x1C,0x1B,0x1A,0x19,0x19,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x18,0x1A,0x19,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x19,0x19,0x19,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1B,0x1B,0x1A,0x19,0x1A,0x1B,0x1B,0x1C,0x1A,0x1C,0x1B,0x1A,0x1B,0x19,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1C,0x1C,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x1B,0x16,0x15,0x16,0x18,0x19,0x1B,0x1A,0x18,0x1A,0x1C,0x1C,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x19,0x1A,0x1A,0x1A,0x1C,0x1B,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x19,0x17,0x16,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x18,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1A,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1B,0x1B,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1B,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1A,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1B,0x1C,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x17,0x16,0x16,0x15,0x15,0x15,0x17,0x19,0x19,0x1C,0x1B,0x16,0x17,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x19,0x1A,0x1C,0x1C,0x1B,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x19,0x19,0x19,0x19,0x1A,0x1B,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x19,0x18,0x18,0x16,0x15,0x15,0x19,0x1B,0x18,0x19,0x1B,0x17,0x1A,0x1B,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x1C,0x1A,0x1B,0x1C,0x1C,0x18,0x1B,0x1B,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1D,0x1B,0x1A,0x1C,0x1C,0x1B,0x1A,0x1C,0x1B,0x1D,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1B,0x1B,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x16,0x1B,0x18,0x16,0x16,0x16,0x16,0x18,0x1C,0x1B,0x1B,0x1A,0x16,0x17,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1A,0x1A,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x18,0x19,0x1A,0x1B,0x1A,0x1A,0x17,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x19,0x16,0x17,0x18,0x19,0x1A,0x1C,0x1C,0x1C,0x1A,0x1A,0x1A,0x19,0x18,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1A,0x1A,0x1B,0x17,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1C,0x1C,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1B,0x1A,0x17,0x18,0x18,0x18,0x18,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x17},
    {0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x16,0x1A,0x15,0x15,0x15,0x15,0x16,0x18,0x1C,0x17,0x19,0x19,0x16,0x16,0x17,0x1C,0x1C,0x1B,0x1A,0x17,0x19,0x1A,0x1B,0x1A,0x1B,0x1C,0x1D,0x1C,0x1C,0x1C,0x18,0x19,0x19,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x18,0x1B,0x1A,0x1B,0x18,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x19,0x1A,0x1B,0x1B,0x1A,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1C,0x1C,0x1D,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1C,0x1D,0x1D,0x1D,0x19,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x1B,0x1C,0x1B,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1B,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1B,0x19,0x17,0x17,0x17,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x17,0x19,0x15,0x15,0x14,0x14,0x15,0x1A,0x19,0x15,0x15,0x15,0x15,0x16,0x16,0x1C,0x1B,0x1B,0x1D,0x16,0x16,0x17,0x1A,0x1C,0x1C,0x19,0x17,0x18,0x1C,0x1A,0x19,0x1A,0x1D,0x1D,0x1D,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1C,0x1B,0x18,0x19,0x1A,0x1C,0x1A,0x18,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1C,0x1B,0x18,0x1B,0x17,0x1B,0x1B,0x1A,0x19,0x19,0x1B,0x1B,0x1B,0x1C,0x1C,0x1A,0x1A,0x1A,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1B,0x1D,0x1D,0x1C,0x16,0x1A,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x1C,0x1D,0x1C,0x1B,0x1C,0x1C,0x1B,0x18,0x1B,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1B,0x1B,0x18,0x17,0x17,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x18,0x19,0x1B,0x1B,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x18,0x17,0x15,0x15,0x14,0x14,0x15,0x17,0x16,0x15,0x15,0x14,0x14,0x15,0x17,0x1D,0x1B,0x15,0x15,0x15,0x15,0x15,0x1B,0x1C,0x1C,0x1A,0x16,0x15,0x17,0x1A,0x1B,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1B,0x1C,0x1B,0x19,0x19,0x19,0x19,0x1A,0x1A,0x18,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1C,0x1A,0x1A,0x19,0x17,0x18,0x18,0x19,0x1B,0x16,0x19,0x1A,0x1B,0x1A,0x1A,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x15,0x1B,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x1C,0x1C,0x1B,0x1C,0x18,0x1B,0x1C,0x1B,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1B,0x1A,0x18,0x1A,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1B,0x1B,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x17,0x16,0x16,0x17,0x16,0x16,0x16,0x16,0x15,0x14,0x14,0x16,0x16,0x15,0x15,0x14,0x14,0x14,0x15,0x18,0x1B,0x17,0x15,0x15,0x14,0x14,0x15,0x1A,0x18,0x16,0x16,0x16,0x15,0x16,0x17,0x17,0x1B,0x19,0x15,0x16,0x19,0x19,0x1C,0x1D,0x1C,0x1C,0x1B,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x1C,0x1B,0x19,0x19,0x1A,0x1B,0x19,0x18,0x1A,0x18,0x1A,0x1A,0x17,0x1B,0x1B,0x1B,0x1A,0x1B,0x17,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x17,0x18,0x1A,0x1C,0x1C,0x1C,0x1A,0x1B,0x1A,0x1B,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1C,0x19,0x17,0x19,0x19,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x1C,0x1C,0x1D,0x1C,0x17,0x1B,0x1A,0x1B,0x1C,0x1D,0x1C,0x1B,0x1B,0x1B,0x18,0x17,0x18,0x19,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1B,0x1A,0x17,0x16,0x16,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x17,0x17},
    {0x1A,0x1B,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x19,0x17,0x16,0x15,0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x16,0x15,0x15,0x14,0x14,0x14,0x15,0x16,0x16,0x15,0x15,0x14,0x14,0x14,0x15,0x18,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x15,0x18,0x17,0x15,0x15,0x18,0x1D,0x1C,0x1A,0x17,0x15,0x17,0x19,0x19,0x19,0x19,0x1B,0x1B,0x18,0x16,0x19,0x1B,0x1C,0x1C,0x19,0x19,0x1C,0x1C,0x18,0x19,0x19,0x1A,0x19,0x1B,0x1A,0x19,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1C,0x1C,0x19,0x1A,0x18,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x1B,0x18,0x19,0x19,0x19,0x1C,0x18,0x1C,0x19,0x1A,0x19,0x16,0x16,0x16,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x19,0x1B,0x1D,0x1D,0x1A,0x17,0x1C,0x19,0x1A,0x1C,0x1D,0x1C,0x1D,0x1D,0x1B,0x1B,0x17,0x18,0x1B,0x1D,0x1D,0x1D,0x1B,0x19,0x1A,0x1A,0x1C,0x1D,0x1D,0x1C,0x1B,0x19,0x17,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x15,0x16,0x15,0x15,0x14,0x14,0x14,0x14,0x15,0x16,0x14,0x14,0x14,0x14,0x14,0x16,0x19,0x15,0x15,0x15,0x15,0x15,0x18,0x1D,0x18,0x1B,0x18,0x16,0x16,0x19,0x1B,0x1A,0x1A,0x17,0x18,0x19,0x1A,0x1C,0x1C,0x1C,0x1B,0x1A,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x19,0x1B,0x16,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1C,0x1C,0x1C,0x1B,0x1A,0x18,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x19,0x19,0x17,0x17,0x19,0x1A,0x1A,0x1D,0x1C,0x18,0x17,0x17,0x1A,0x1A,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x18,0x1C,0x1D,0x1D,0x19,0x19,0x1C,0x1A,0x1A,0x1C,0x1D,0x1C,0x1E,0x1B,0x1C,0x1C,0x18,0x18,0x1D,0x1D,0x1D,0x1D,0x18,0x15,0x15,0x15,0x18,0x1C,0x1D,0x1C,0x1C,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x18,0x16,0x15,0x15,0x16,0x16,0x15,0x15,0x14,0x15,0x14,0x14,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x15,0x15,0x14,0x15,0x14,0x14,0x15,0x1A,0x1A,0x15,0x16,0x16,0x16,0x16,0x19,0x1C,0x1A,0x1B,0x17,0x16,0x17,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1C,0x1C,0x1A,0x1B,0x1D,0x1C,0x1C,0x19,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x19,0x18,0x1A,0x19,0x1B,0x1A,0x1C,0x1B,0x1B,0x18,0x16,0x16,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x17,0x16,0x15,0x15,0x16,0x16,0x17,0x1B,0x16,0x16,0x18,0x16,0x1A,0x1C,0x1A,0x1A,0x1C,0x1D,0x1C,0x1F,0x1D,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1B,0x19,0x16,0x15,0x17,0x1B,0x1D,0x1B,0x1B,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x18,0x18,0x19,0x1A,0x19,0x19,0x17,0x15,0x15,0x16,0x16,0x16,0x15,0x14,0x14,0x14,0x15,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x14,0x15,0x14,0x17,0x15,0x15,0x15,0x15,0x15,0x16,0x1B,0x1C,0x16,0x15,0x16,0x16,0x16,0x1A,0x1C,0x1B,0x1C,0x16,0x16,0x1B,0x1B,0x1B,0x1C,0x1A,0x18,0x1B,0x19,0x1A,0x19,0x1C,0x1B,0x1A,0x1B,0x19,0x19,0x1A,0x19,0x18,0x18,0x18,0x17,0x19,0x17,0x19,0x1B,0x19,0x17,0x17,0x15,0x1B,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1C,0x1B,0x1A,0x19,0x17,0x1A,0x1D,0x17,0x16,0x16,0x16,0x1A,0x1A,0x19,0x1B,0x1D,0x1D,0x1C,0x1F,0x1F,0x1A,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1C,0x1C,0x1D,0x1C,0x1B,0x1C,0x1D,0x1D,0x1B,0x1B,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x18,0x18,0x19,0x19,0x19,0x17,0x16,0x15,0x15,0x15,0x16,0x16,0x15,0x14,0x14,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x15,0x15,0x15,0x15,0x1A,0x1A,0x16,0x15,0x15,0x16,0x16,0x1B,0x1C,0x16,0x18,0x15,0x15,0x16,0x1C,0x1C,0x1A,0x18,0x17,0x18,0x19,0x1B,0x1C,0x1C,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x19,0x19,0x1B,0x1B,0x1B,0x1A,0x1C,0x1A,0x19,0x17,0x17,0x16,0x19,0x1C,0x19,0x18,0x1A,0x19,0x1A,0x1A,0x1B,0x19,0x1B,0x1C,0x1C,0x1C,0x1C,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x19,0x1A,0x1B,0x19,0x17,0x17,0x1A,0x1D,0x18,0x18,0x1C,0x1D,0x1C,0x1D,0x1F,0x1F,0x1E,0x19,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1C,0x1D,0x1D,0x1A,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x14,0x15,0x15,0x14,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x16,0x15,0x15,0x15,0x17,0x1D,0x19,0x15,0x15,0x15,0x15,0x15,0x1C,0x19,0x18,0x19,0x16,0x16,0x1A,0x1D,0x1C,0x1C,0x1A,0x19,0x1A,0x1D,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x1A,0x19,0x1B,0x18,0x16,0x16,0x16,0x17,0x19,0x1B,0x1B,0x1A,0x18,0x19,0x1B,0x1C,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x17,0x1B,0x1C,0x1B,0x1C,0x1D,0x1C,0x1D,0x1C,0x1B,0x1C,0x1D,0x1C,0x1B,0x1C,0x1D,0x1E,0x1B,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x16,0x15,0x16,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x17,0x16,0x15,0x14,0x14,0x14,0x16,0x1D,0x15,0x15,0x15,0x15,0x15,0x18,0x1C,0x1A,0x1C,0x18,0x16,0x16,0x1A,0x1B,0x1A,0x19,0x1A,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x19,0x18,0x15,0x19,0x1D,0x1C,0x1B,0x18,0x18,0x17,0x17,0x19,0x1C,0x1B,0x1B,0x1B,0x1C,0x1C,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x15,0x19,0x19,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1B,0x1C,0x1D,0x1D,0x1C,0x1B,0x1B,0x1B,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x19,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x16},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x18,0x18,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x15,0x18,0x17,0x15,0x15,0x14,0x15,0x14,0x17,0x17,0x15,0x15,0x14,0x14,0x15,0x19,0x1D,0x16,0x16,0x15,0x15,0x16,0x16,0x1B,0x18,0x1B,0x15,0x16,0x1B,0x1C,0x1C,0x1B,0x19,0x16,0x17,0x18,0x19,0x19,0x1C,0x1D,0x1A,0x17,0x16,0x17,0x16,0x18,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x19,0x15,0x18,0x1B,0x19,0x1A,0x18,0x16,0x17,0x19,0x19,0x1B,0x1C,0x1A,0x1B,0x1D,0x1D,0x1D,0x1B,0x1B,0x18,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x19,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x1B,0x1A,0x19,0x18,0x18,0x17,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x14,0x14,0x15,0x14,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x19,0x1A,0x15,0x15,0x14,0x15,0x15,0x16,0x15,0x16,0x17,0x15,0x16,0x17,0x1C,0x1C,0x18,0x18,0x16,0x16,0x1B,0x1C,0x1C,0x19,0x18,0x1A,0x1B,0x1C,0x1A,0x19,0x19,0x1A,0x1C,0x1B,0x1C,0x1C,0x1C,0x18,0x18,0x1A,0x1A,0x1A,0x1A,0x1A,0x18,0x15,0x19,0x1B,0x1B,0x1D,0x17,0x16,0x17,0x16,0x17,0x16,0x16,0x16,0x1C,0x1D,0x1C,0x1B,0x1B,0x18,0x16,0x16,0x16,0x16,0x15,0x15,0x16,0x18,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x17,0x17,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x18,0x19,0x19,0x1A,0x1A,0x19,0x18,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x14,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x16,0x16,0x15,0x15,0x14,0x14,0x15,0x19,0x17,0x15,0x15,0x15,0x16,0x15,0x1C,0x17,0x19,0x19,0x15,0x15,0x16,0x1C,0x1A,0x16,0x16,0x16,0x17,0x1C,0x1D,0x1C,0x1A,0x1B,0x1C,0x1C,0x1D,0x1C,0x1C,0x18,0x15,0x16,0x17,0x18,0x19,0x1A,0x16,0x15,0x1A,0x18,0x1B,0x1A,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x1B,0x1A,0x1D,0x1B,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x1B,0x1D,0x18,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x19,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17},
    {0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x14,0x14,0x15,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x15,0x14,0x14,0x14,0x14,0x15,0x16,0x1A,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x15,0x1A,0x19,0x15,0x16,0x19,0x1C,0x18,0x19,0x1A,0x1C,0x1C,0x1C,0x1D,0x1C,0x1B,0x17,0x15,0x14,0x14,0x14,0x15,0x15,0x17,0x1B,0x19,0x17,0x17,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x1B,0x1C,0x19,0x1C,0x1B,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x1D,0x17,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x19,0x18,0x16,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17},
    {0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x16,0x15,0x14,0x15,0x16,0x15,0x15,0x14,0x14,0x14,0x15,0x14,0x17,0x18,0x15,0x15,0x14,0x14,0x15,0x16,0x1A,0x15,0x15,0x15,0x15,0x15,0x16,0x1C,0x19,0x1A,0x17,0x17,0x19,0x1C,0x1D,0x1C,0x1A,0x1A,0x1B,0x1B,0x19,0x16,0x14,0x15,0x18,0x1C,0x1C,0x19,0x18,0x17,0x15,0x15,0x15,0x15,0x15,0x15,0x18,0x19,0x19,0x1C,0x1B,0x16,0x16,0x15,0x14,0x14,0x14,0x15,0x15,0x16,0x16,0x1B,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x16,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17},
    {0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x17,0x15,0x15,0x15,0x14,0x14,0x15,0x14,0x15,0x15,0x14,0x15,0x14,0x14,0x14,0x15,0x15,0x14,0x15,0x14,0x15,0x15,0x16,0x1B,0x16,0x19,0x15,0x16,0x16,0x1B,0x1C,0x17,0x18,0x15,0x15,0x18,0x1B,0x1A,0x16,0x19,0x1A,0x1C,0x1B,0x19,0x1A,0x1D,0x1C,0x1B,0x19,0x18,0x15,0x15,0x18,0x17,0x1A,0x1C,0x1B,0x16,0x16,0x15,0x14,0x14,0x14,0x14,0x15,0x17,0x16,0x1A,0x15,0x15,0x14,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x16,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17},
    {0x19,0x19,0x19,0x18,0x19,0x19,0x1A,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x17,0x16,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x14,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x17,0x1C,0x16,0x14,0x14,0x15,0x15,0x1B,0x19,0x17,0x1C,0x16,0x15,0x15,0x17,0x1D,0x1B,0x19,0x17,0x1A,0x1B,0x19,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x19,0x1C,0x1D,0x1C,0x1C,0x1C,0x16,0x16,0x15,0x14,0x14,0x14,0x14,0x15,0x16,0x17,0x1A,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16},
    {0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x18,0x19,0x15,0x14,0x14,0x15,0x16,0x1B,0x16,0x15,0x14,0x14,0x15,0x15,0x16,0x18,0x17,0x1B,0x16,0x16,0x1B,0x1D,0x1D,0x1D,0x1D,0x1B,0x1C,0x1D,0x1D,0x1C,0x1A,0x1D,0x1C,0x1C,0x1A,0x19,0x16,0x16,0x15,0x14,0x14,0x15,0x17,0x16,0x1A,0x18,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x16,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x14,0x14,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x15,0x16,0x17,0x14,0x14,0x14,0x14,0x15,0x15,0x14,0x14,0x15,0x14,0x16,0x17,0x15,0x15,0x14,0x14,0x15,0x15,0x16,0x17,0x16,0x1A,0x15,0x16,0x18,0x1C,0x1D,0x19,0x1A,0x16,0x16,0x19,0x1D,0x1D,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x18,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x19,0x16,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x19,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x16},
    {0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x16,0x16,0x16,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x14,0x14,0x13,0x13,0x14,0x14,0x14,0x14,0x13,0x19,0x15,0x15,0x15,0x14,0x14,0x15,0x14,0x17,0x15,0x14,0x15,0x14,0x14,0x14,0x14,0x16,0x18,0x15,0x14,0x14,0x15,0x16,0x1C,0x1C,0x17,0x1C,0x17,0x15,0x15,0x1B,0x1C,0x1B,0x19,0x19,0x1B,0x1C,0x1C,0x1B,0x19,0x16,0x16,0x16,0x17,0x1B,0x18,0x16,0x15,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x19,0x17,0x17,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x19,0x1A,0x1A,0x19,0x19,0x18,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x15,0x14,0x14,0x14,0x15,0x15,0x15,0x14,0x15,0x14,0x14,0x14,0x14,0x15,0x15,0x14,0x14,0x14,0x16,0x17,0x1D,0x19,0x15,0x15,0x15,0x15,0x15,0x16,0x18,0x17,0x1A,0x18,0x16,0x19,0x1D,0x1C,0x1A,0x16,0x17,0x17,0x18,0x1B,0x18,0x16,0x15,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17},
    {0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x19,0x19,0x18,0x19,0x19,0x19,0x18,0x17,0x17,0x17,0x17,0x18,0x19,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x15,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x14,0x14,0x15,0x17,0x1C,0x16,0x15,0x15,0x14,0x15,0x15,0x16,0x16,0x16,0x19,0x17,0x16,0x15,0x1B,0x1C,0x1B,0x18,0x16,0x16,0x1B,0x1B,0x18,0x16,0x15,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x14,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x18,0x18,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x19,0x15,0x14,0x14,0x14,0x18,0x19,0x15,0x15,0x14,0x14,0x14,0x15,0x19,0x16,0x15,0x15,0x14,0x15,0x15,0x1A,0x1C,0x16,0x1C,0x1A,0x15,0x15,0x17,0x19,0x16,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x16,0x17,0x18,0x18,0x19,0x19,0x18,0x19,0x19,0x18,0x17,0x18,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16},
    {0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x19,0x19,0x1A,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x17,0x15,0x14,0x14,0x17,0x17,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x14,0x14,0x14,0x15,0x1A,0x1A,0x15,0x16,0x17,0x15,0x15,0x15,0x19,0x16,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16},
    {0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x1A,0x1A,0x19,0x18,0x19,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x15,0x14,0x14,0x15,0x14,0x14,0x14,0x15,0x15,0x15,0x14,0x15,0x14,0x14,0x14,0x14,0x1A,0x16,0x14,0x15,0x14,0x14,0x15,0x15,0x19,0x16,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x19,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x18,0x18,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x14,0x15,0x14,0x14,0x14,0x15,0x17,0x15,0x14,0x14,0x14,0x14,0x14,0x15,0x19,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17},
    {0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x18,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x16,0x17,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x16,0x17,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x19,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17},
    {0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x19,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x16,0x17,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x17,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x17},
    {0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x15,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x1B,0x1B,0x1B,0x1C,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x14,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x19,0x1A,0x1A,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x17,0x17,0x17},
    {0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x16,0x15,0x15,0x16,0x16,0x17,0x17,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x19,0x18,0x18,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17},
    {0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x17,0x16,0x17,0x17,0x17,0x17,0x17,0x17},
    {0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x19,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x19,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x18,0x1A,0x1B,0x1B,0x1B,0x1C,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x18,0x18,0x19,0x19,0x1A,0x19,0x1A,0x19,0x18,0x18,0x17,0x18,0x19,0x18,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x18,0x17,0x16,0x16,0x15,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x17,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0x17},
    {0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x18,0x18,0x17,0x16,0x16,0x15,0x16,0x15,0x15,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x18,0x19,0x1A,0x19,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x18,0x19,0x18,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x16,0x16,0x17,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x16,0x17,0x16,0x17,0x18,0x19,0x18,0x18,0x19,0x18,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17},
    {0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x16,0x15,0x15,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x18,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x14,0x14,0x13,0x13,0x13,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x19,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17},
    {0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x16,0x15,0x16,0x16,0x15,0x16,0x16,0x17,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x16,0x16,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x16},
    {0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x18,0x17,0x17,0x16,0x16,0x15,0x16,0x15,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x19,0x19,0x19,0x1B,0x1B,0x1A,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x18,0x18,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17},
    {0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x16,0x16,0x15,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1C,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x19,0x19,0x1A,0x19,0x19,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x1A,0x19,0x19,0x18,0x18,0x18,0x19,0x1A,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x15,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x15,0x16,0x16,0x15,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x17},
    {0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1A,0x19,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x19,0x18,0x19,0x1A,0x19,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x17,0x17},
    {0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x17,0x16,0x16,0x15,0x16,0x16,0x15,0x16,0x16,0x17,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x19,0x19,0x19,0x1B,0x1B,0x1A,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x18,0x18,0x19,0x18,0x18,0x18,0x17,0x18,0x17,0x18,0x19,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x15,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x15,0x16,0x16,0x15,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17},
    {0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x17,0x17,0x16,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x1A,0x1A,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x15,0x15,0x16,0x17,0x17,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16},
    {0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x17,0x16,0x16,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x1A,0x19,0x1A,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x19,0x19,0x18,0x19,0x18,0x19,0x19,0x19,0x18,0x19,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x17,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x15,0x16,0x16,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16},
    {0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x16,0x16,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1B,0x1C,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x1A,0x1A,0x19,0x19,0x18,0x18,0x19,0x19,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x19,0x19,0x18,0x18,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x16,0x15,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15},
    {0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x18,0x17,0x17,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x17,0x16,0x17,0x17,0x16,0x16,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x15,0x15,0x16,0x17,0x18,0x19,0x19,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15},
    {0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1B,0x1A,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x18,0x17,0x18,0x18,0x17,0x16,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x17,0x18,0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x15,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15},
    {0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1D,0x1C,0x1B,0x1B,0x1C,0x1C,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x18,0x17,0x18,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x16,0x16,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x17,0x17,0x18,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x16,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15},
    {0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x18,0x19,0x19,0x1A,0x19,0x18,0x17,0x17,0x18,0x18,0x17,0x17,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x17,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15},
    {0x19,0x18,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x1A,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1B,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x18,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x18,0x18,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x16,0x18,0x18,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x17,0x17,0x17,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x16,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15,0x15},
    {0x19,0x19,0x18,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x16,0x17,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x19,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x14,0x14,0x14,0x15,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x17,0x16,0x16,0x15,0x15,0x15},
    {0x1A,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1C,0x1B,0x1C,0x1C,0x1B,0x1A,0x1A,0x1B,0x1C,0x1B,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1A,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x19,0x1B,0x1B,0x1C,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x18,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x17,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x19,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x15,0x16,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x16,0x16,0x15},
    {0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x19,0x17,0x18,0x18,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x18,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x18,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x16,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x19,0x19,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x15,0x16,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x16,0x16},
    {0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1C,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x19,0x19,0x18,0x18,0x1A,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1B,0x1A,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x19,0x1A,0x19,0x19,0x19,0x18,0x18,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x19,0x1A,0x19,0x19,0x19,0x18,0x19,0x18,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x15,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x17},
    {0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x18,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x15,0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18},
    {0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1A,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x15,0x16,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x18},
    {0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x19,0x1A,0x1A,0x19,0x18,0x19,0x19,0x1A,0x19,0x19,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x19},
    {0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1C,0x1C,0x1B,0x1C,0x1B,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x19,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1B,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x15,0x16,0x17,0x17,0x18,0x18,0x19},
    {0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x19,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x18,0x19,0x1A,0x1A,0x19,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x15,0x16,0x17,0x17,0x18},
    {0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x1A,0x19,0x1A,0x19,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x18,0x18,0x17,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x15,0x16,0x16,0x17},
    {0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1B,0x1C,0x1C,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x1A,0x19,0x19,0x19,0x1B,0x1B,0x1B,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x15,0x16},
    {0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x18,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x18,0x18,0x19,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14},
    {0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x18,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1D,0x1C,0x1D,0x1C,0x1C,0x1C,0x1A,0x1B,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1C,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x19,0x18,0x19,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1C,0x1C,0x1B,0x1A,0x1A,0x1B,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1B,0x1C,0x1B,0x1C,0x1A,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x18,0x17,0x17,0x19,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1D,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1A,0x19,0x17,0x18,0x18,0x19,0x1B,0x1B,0x1A,0x19,0x18,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x1A,0x1B,0x1A,0x19,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x19,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x18,0x19,0x19,0x19,0x1A,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1C,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x18,0x19,0x1B,0x1B,0x1A,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x15,0x15,0x15,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x1A,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1D,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x1A,0x19,0x19,0x19,0x1A,0x1B,0x1A,0x19,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x15,0x15,0x15,0x14,0x15,0x15,0x15,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x18,0x1A,0x1B,0x1A,0x19,0x19,0x1A,0x1A,0x19,0x1A,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13,0x13},
    {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x19,0x18,0x19,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1C,0x1B,0x1A,0x19,0x19,0x1A,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x15,0x15,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x13,0x13},
    {0x18,0x18,0x19,0x19,0x18,0x18,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x17,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x1A,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x15,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13},
    {0x17,0x18,0x18,0x19,0x19,0x18,0x18,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1A,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1A,0x1A,0x19,0x1A,0x1C,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x15,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14},
    {0x16,0x17,0x17,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1B,0x1B,0x1C,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1A,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14,0x14,0x14},
    {0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x18,0x18,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1B,0x1B,0x1A,0x1A,0x1B,0x1C,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x14,0x14,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14,0x14,0x14},
    {0x15,0x15,0x16,0x17,0x17,0x19,0x19,0x1A,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x14},
    {0x14,0x14,0x15,0x16,0x16,0x17,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1D,0x1E,0x1D,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x15,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x13,0x13,0x14,0x15,0x15,0x16,0x17,0x18,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1C,0x1D,0x1E,0x1D,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1C,0x1D,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x15,0x16,0x15,0x15,0x14,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x12,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x12,0x12,0x13,0x14,0x15,0x15,0x16,0x17,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x18,0x19,0x18,0x18,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x13,0x13,0x12,0x13,0x13,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x13,0x12,0x12,0x13,0x14,0x14,0x15,0x15,0x16,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1E,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x18,0x18,0x17,0x17,0x17,0x16,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x13,0x12,0x13,0x13,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x12,0x12,0x13,0x12,0x13,0x13,0x14,0x15,0x15,0x16,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x16,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x15,0x15,0x14,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13},
    {0x12,0x12,0x12,0x12,0x12,0x13,0x13,0x14,0x15,0x15,0x16,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1C,0x1D,0x1D,0x1E,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1D,0x1D,0x1D,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x16,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x14,0x14,0x13,0x13,0x12,0x12,0x13,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x13,0x13,0x13,0x13,0x13},
    {0x12,0x12,0x13,0x12,0x12,0x12,0x12,0x13,0x14,0x15,0x15,0x16,0x17,0x18,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1E,0x1D,0x1D,0x1D,0x1D,0x1E,0x1E,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x16,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x14,0x14,0x14,0x13,0x13,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12},
    {0x12,0x12,0x12,0x13,0x12,0x12,0x12,0x12,0x13,0x14,0x15,0x15,0x16,0x16,0x17,0x18,0x18,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x18,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x17,0x18,0x19,0x19,0x19,0x1A,0x1A,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1D,0x1C,0x1C,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1A,0x1A,0x19,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x16,0x16,0x15,0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x13,0x13,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12},
    {0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x13,0x14,0x15,0x15,0x15,0x16,0x17,0x18,0x18,0x19,0x18,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x17,0x18,0x18,0x18,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x18,0x17,0x18,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x17,0x17,0x18,0x18,0x19,0x19,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1D,0x1D,0x1C,0x1D,0x1D,0x1C,0x1C,0x1D,0x1D,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1D,0x1D,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1B,0x1B,0x1B,0x1B,0x1A,0x1A,0x1A,0x19,0x19,0x18,0x18,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x16,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x14,0x14,0x14,0x13,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12}
};

#else

unsigned char const sample_bitmap[192][256] = {
    {0x65,0x65,0x65,0x65,0x66,0x6E,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA4,0xA4,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0xA4,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xA5,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5D,0x5D},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA4,0xA4,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x65,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0xA4,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5D,0x5D,0x5D,0x5C},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0xA4,0xA4,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x64,0x64,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xA4,0xA4,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0xA4,0xA4,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xAD,0xAD,0xAD,0xA5,0xA5,0xA4,0xA4,0x64,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0xA4,0xA5,0xAD,0xAE,0xAE,0xB6,0xB6,0xAE,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D},
    {0xAD,0x65,0x65,0x65,0x65,0x65,0xA6,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x6E,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA4,0xA4,0x5C,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x64,0x64,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0xA5,0xAD,0xAD,0xAE,0xB6,0xB6,0xAE,0xAE,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D},
    {0xAE,0xAE,0xA5,0x65,0x65,0x65,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAE,0xAD,0xA5,0xA5,0xA4,0xA4,0xA4,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C,0x5D,0x5D},
    {0xF6,0xAD,0xAD,0xAE,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA4,0xA4,0x64,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x5D,0x5D,0x65,0x5D,0x5D,0x5D,0x5D,0x5D},
    {0xF6,0xAE,0xAD,0xAE,0xAE,0xA6,0x65,0x65,0x65,0x65,0x65,0xA6,0xA6,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xAD,0xAD,0xA5,0xA5,0xA4,0xA4,0xA4,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D},
    {0xF6,0xF6,0xAE,0xAE,0xAE,0xAE,0xA6,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0xAD,0xAD,0xA5,0xA4,0xA4,0x64,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xF6,0xB6,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x5D,0x5D},
    {0xF6,0xF6,0xAE,0xAE,0xAE,0xA5,0xA5,0xA6,0xA6,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA4,0xA4,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xB6,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0xA4,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x65,0x5D,0x5D},
    {0xF6,0xF6,0xF6,0xF6,0xAE,0xAE,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xAE,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xB6,0xF6,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xF6,0xB6,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x65,0x65,0x65,0x65,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5C,0x5C,0x5D,0x5D,0x5D},
    {0xF6,0xF6,0xF6,0xF6,0xF6,0xAE,0xAE,0xAE,0xA6,0xA5,0xA5,0x65,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x53,0x53,0x52,0x52,0x53,0x53,0x52,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA4,0xA5,0xA5,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5C,0x5C,0x5C},
    {0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xAE,0xAE,0xAE,0xA5,0x65,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x64,0x5C,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xB6,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C},
    {0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xAE,0xAE,0xAE,0xA5,0x65,0x65,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xF6,0xF6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D},
    {0xF6,0xF6,0xF6,0xF6,0xF5,0xF6,0xF6,0xF6,0xF6,0xAE,0xAE,0xAE,0xAE,0xA6,0xA5,0xA5,0xAE,0xAE,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0xA5,0xA5,0x65,0x64,0x5C,0x5C,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xB6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5C,0x5D,0x5D,0x5D,0x5D},
    {0xF6,0xF6,0xF6,0xF6,0xF5,0xED,0xF5,0xF6,0xF6,0xF6,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0x65,0xA6,0xA5,0xA6,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF7,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xAE,0xAE,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xF6,0xF6,0xF6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0x65,0x64,0x64,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0xA4,0xA4,0xA5,0xA5,0xAD,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C},
    {0xF6,0xF6,0xF6,0xF6,0xED,0xED,0xED,0xF5,0xF6,0xF6,0xF6,0xAD,0xAE,0xAE,0xAE,0xA6,0xA6,0xA5,0x65,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0xA6,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xB6,0xF6,0xF6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xFF,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA4,0xA5,0xA5,0xAD,0xAD,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C},
    {0xF6,0xF6,0xF6,0xF6,0xF6,0xAD,0xED,0xED,0xF5,0xF6,0xF6,0xAE,0xAD,0xA5,0xA5,0xA6,0xAE,0xAE,0xA6,0xA5,0x65,0xA5,0xA6,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xB6,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C,0x5D,0x5D,0x5D,0x5D},
    {0xF6,0xF6,0xF6,0xF6,0xF6,0xAD,0xAD,0xED,0xED,0xF5,0xF6,0xF6,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xA5,0xA5,0x65,0x65,0xAE,0xAE,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0xAD,0xAD,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xB6,0xF6,0xF6,0xB6,0xF6,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0x65,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5C,0x64,0xA4,0xA4,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x65,0x65,0x5D,0x5D,0x5D,0x5C,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C,0x5C,0x5D},
    {0xF6,0xF6,0xF6,0xF6,0xF6,0xAD,0xAD,0xED,0xED,0xED,0xF5,0xF6,0xF6,0xAD,0xA5,0xA5,0xAE,0xAE,0xAE,0xAE,0xAE,0xA6,0x65,0x65,0x65,0xAE,0x66,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0xAD,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xB6,0xAE,0xAE,0xB6,0xF6,0xF6,0xF6,0xF7,0xFF,0xFF,0xF7,0xF7,0xF7,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xAD,0xAD,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0xA4,0xA4,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C},
    {0xFE,0xF6,0xF6,0xF6,0xF6,0xAD,0xAD,0xAD,0xED,0xED,0xF5,0xF5,0xF6,0xAD,0xA5,0xA5,0xA5,0xA5,0xAE,0xAE,0xAE,0xAE,0xA6,0xA5,0xA5,0x65,0x65,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAE,0xAE,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xAE,0xAE,0xB6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xF6,0xF7,0xFF,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xFE,0xFF,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF7,0xB6,0xB6,0xB6,0xF6,0xF6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0x65,0xA5,0xA5,0xAD,0xA5,0xA5,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0xA4,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x5D,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C,0x5D,0x5D,0x5D,0x5D,0x5C},
    {0xF6,0xF6,0xF6,0xF6,0xF6,0xAD,0xA4,0xAD,0xAD,0xED,0xED,0xED,0xF6,0xF6,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAE,0xAE,0xA6,0xAE,0xAE,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xFF,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xF6,0xF7,0xF6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0xA4,0xA4,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C,0x5C,0x5D,0x5D},
    {0xFE,0xFE,0xF6,0xF6,0xF6,0xAD,0xA4,0xAD,0xAD,0xED,0xED,0xED,0xF5,0xF6,0xAD,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xAE,0xAE,0xAE,0xA5,0xA5,0x65,0x5C,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xFE,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xFE,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA4,0xA5,0xA5,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5D,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C},
    {0xFE,0xFE,0xF6,0xF6,0xF6,0xAD,0xA4,0xA5,0xAD,0xED,0xED,0xED,0xF5,0xF6,0xED,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0x64,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF7,0xFF,0xFF,0xFF,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFE,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xF6,0xFF,0xF7,0xF6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x5C,0x5C,0xA4,0xA4,0xA5,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x5D,0x5C,0x5D,0x5C,0x5C,0x65,0x65,0x5D,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xFE,0xFE,0xF6,0xF6,0xF6,0xAD,0xA4,0xA4,0xAD,0xAD,0xED,0xED,0xED,0xF5,0xF5,0xAD,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF7,0xFF,0xF7,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFE,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5C,0x64,0xA4,0xA5,0xA5,0xAD,0xA5,0x65,0x65,0x65,0x5C,0x5C,0x5D,0x5C,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xFE,0xFE,0xF6,0xF6,0xF6,0xAD,0xA4,0xA4,0xAD,0xAD,0xED,0xED,0xED,0xED,0xF6,0xAD,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xB6,0xAE,0xAE,0xB6,0xF6,0xF6,0xB6,0xF6,0xF6,0xFF,0xFF,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xF7,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFE,0xF6,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xF6,0xF7,0xF6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xFE,0xFE,0xF6,0xF6,0xF5,0xAD,0xA4,0xA4,0xA4,0xAD,0xAD,0xED,0xED,0xED,0xF5,0xED,0xA5,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0x64,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xFF,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFE,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xFE,0xFE,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xFE,0xFF,0xF6,0xF6,0xF6,0xB6,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0x65,0x5C,0x5C,0x5D,0x5D,0x5C,0x5C,0x5C,0x5D,0x5D,0x5C,0x5C,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xFE,0xFE,0xF6,0xF6,0xED,0xA4,0xA4,0xA4,0xA4,0xAD,0xAD,0xED,0xED,0xED,0xF5,0xF5,0xA5,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xF6,0xFF,0xFF,0xFF,0xF7,0xF7,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFE,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xF7,0xF6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0xA4,0xA4,0xA5,0xA5,0xA5,0x64,0x5C,0x5C,0x5D,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5D,0x5D,0x5D,0x5D,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xFE,0xFE,0xF6,0xF6,0xED,0xA4,0xAD,0xA4,0xA4,0xAD,0xAD,0xED,0xED,0xED,0xED,0xF5,0xAD,0x64,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5C,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF7,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFE,0xF6,0xFE,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xFE,0xF6,0xF6,0xF6,0xF6,0xFE,0xFF,0xFF,0xFF,0xFE,0xFE,0xFF,0xFF,0xF6,0xF6,0xB6,0xB6,0xB6,0xF6,0xF6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x65,0x64,0x5C,0x5C,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5D,0x5D,0x5D,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xFE,0xFE,0xF6,0xF6,0xED,0xA5,0xAD,0xA4,0xA4,0xAD,0xAD,0xAD,0xED,0xED,0xED,0xF5,0xAD,0x64,0x65,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xF6,0xF7,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5D,0x5C,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xFE,0xFE,0xF6,0xF6,0xED,0xAD,0xAD,0xA4,0xA4,0xAD,0xAD,0xAD,0xED,0xED,0xED,0xF5,0xAD,0x5C,0x64,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xF6,0xF7,0xFF,0xFF,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x64,0x5C,0x64,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xFE,0xF6,0xF6,0xF6,0xED,0xED,0xED,0xAC,0xA4,0xED,0xAD,0xAD,0xED,0xED,0xED,0xED,0xAD,0x5C,0x5C,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF7,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFE,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFE,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xF6,0xF6,0xF6,0xF6,0xED,0xF6,0xF6,0xED,0xA4,0xF6,0xED,0xAD,0xAD,0xED,0xED,0xF5,0xED,0x5C,0x5C,0x5C,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x52,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xB6,0xF6,0xFF,0xF7,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFE,0xFE,0xFF,0xFF,0xFF,0xF7,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xFE,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x5C,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xF6,0xF6,0xF6,0xED,0xAD,0xF6,0xFE,0xF6,0xAC,0xF6,0xED,0xAD,0xAD,0xED,0xED,0xF5,0xED,0xA4,0x64,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xB6,0xB6,0xB6,0xB6,0xF6,0xF7,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFE,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xF6,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x64,0x64,0x65,0x65,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x5C,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xF6,0xF6,0xF5,0xAD,0xA4,0xED,0xF6,0xF6,0xAC,0xED,0xAD,0xAC,0xAD,0xED,0xED,0xF5,0xED,0xA4,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xFF,0xFF,0xFF,0xFE,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x64,0x65,0xA5,0x65,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xF6,0xF6,0xED,0xA4,0xA4,0xAD,0xF5,0xAD,0xA4,0xAD,0xAC,0xAC,0xAD,0xED,0xED,0xF5,0xED,0xA4,0xA4,0x64,0x5C,0x5B,0x5B,0x5B,0x53,0x52,0x53,0x53,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xFF,0xFF,0xF7,0xF7,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFE,0xFF,0xFF,0xFF,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xFE,0xFE,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xF6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0x64,0x64,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xF6,0xF6,0xAD,0xA4,0xA4,0xA4,0xAD,0xA4,0xA4,0xAD,0xA4,0xAD,0xED,0xED,0xED,0xF5,0xED,0xA4,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFE,0xF6,0xF6,0xB6,0xF6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xF6,0xF5,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xAD,0xED,0xED,0xED,0xF5,0xED,0xA4,0x64,0x5C,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xF6,0xFF,0xFE,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xF6,0xAD,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xAD,0xED,0xED,0xED,0xF5,0xED,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xB6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFE,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xF5,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xAC,0xAD,0xED,0xED,0xF5,0xF5,0xAD,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xB6,0xB6,0xF6,0xF6,0xFE,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xFE,0xFF,0xFF,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xAD,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xAC,0xAD,0xED,0xED,0xF5,0xF5,0xAD,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xB6,0xB6,0xB6,0xF6,0xFF,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xF7,0xF6,0xB6,0xB6,0xB6,0xF6,0xF6,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xAC,0xED,0xED,0xED,0xED,0xED,0xA4,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xB6,0xB6,0xF6,0xFF,0xF6,0xF6,0xFE,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xFE,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xAE,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xA4,0x9B,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xAD,0xED,0xED,0xED,0xED,0xED,0xA4,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xB6,0xB6,0xB6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x9B,0x9B,0x9B,0x9B,0xA4,0xA4,0xA4,0xA4,0xA4,0xAC,0xAD,0xED,0xED,0xED,0xED,0xED,0xA4,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFF,0xF6,0xF6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x9B,0x9B,0x9B,0x9B,0x9B,0xA4,0x9B,0x9B,0xA4,0xAD,0xED,0xED,0xED,0xED,0xED,0xAC,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xB6,0xB6,0xB6,0xF6,0xF6,0xFF,0xFF,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,0xA4,0xA4,0xED,0xED,0xED,0xED,0xED,0xED,0xA4,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x64,0x64,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x9B,0x9B,0x9B,0x9B,0x9B,0x5B,0x5B,0xA4,0xAC,0xED,0xED,0xED,0xED,0xED,0xAD,0x9C,0x5B,0x5B,0x5B,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xF6,0xF6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x9B,0x9B,0x5B,0x9B,0x9B,0x5B,0x9B,0xA4,0xAD,0xED,0xED,0xED,0xED,0xED,0xA4,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x9B,0x5B,0x5B,0x5B,0x5B,0x5B,0xA4,0xAC,0xED,0xED,0xED,0xED,0xED,0xAD,0xA4,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x5B,0x5B,0x5B,0x5B,0x9B,0xA4,0xED,0xED,0xED,0xED,0xED,0xED,0xA4,0xA4,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x64,0x64,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xA5,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x5B,0x5B,0x5B,0x5B,0xA4,0xAC,0xAD,0xED,0xED,0xED,0xED,0xAD,0xA4,0xA4,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x64,0x64,0x64,0x65,0x65,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0x64,0xA5,0x64,0x64,0x64,0xA5,0x64,0xA5,0x64,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x5B,0x5B,0x5B,0x9B,0xA4,0xAD,0xED,0xED,0xED,0xED,0xAD,0xAD,0xA4,0x5B,0x5B,0x5B,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x64,0x64,0xA5,0x65,0x64,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x5B,0x5B,0x5B,0xA4,0xAC,0xAD,0xED,0xED,0xED,0xED,0xF5,0xAD,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x64,0xA5,0x65,0x64,0x64,0x64,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x5B,0x5B,0x9B,0xA4,0xAC,0xAD,0xED,0xED,0xED,0xF6,0xAD,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x64,0x64,0x65,0x65,0x64,0x64,0x65,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x5B,0x5B,0xA4,0xAC,0xAC,0xAD,0xED,0xED,0xF6,0xED,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x64,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x64,0x65,0x64,0x64,0x64,0x64,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x5B,0xA4,0xA4,0xAC,0xAD,0xAD,0xED,0xF6,0xAD,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0x65,0xA5,0x65,0x65,0x64,0x64,0x64,0x65,0x64,0x64,0x65,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x64,0xA5,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0x64,0x64,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x9B,0xA4,0xAC,0xAC,0xAD,0xED,0xF6,0xAD,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0x64,0x5C,0x5C,0x5B,0x5B,0xA4,0xA4,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x64,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0xA4,0xA4,0xAC,0xAC,0xED,0xF6,0xAD,0x9C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0x65,0x65,0x65,0x64,0x64,0x64,0x65,0x64,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xA4,0xB6,0x64,0x5B,0x5B,0xAB,0xF5,0xAD,0x5B,0x5B,0x64,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA4,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xA4,0xA4,0xA4,0xAC,0xED,0xF6,0xAD,0xA4,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0xA5,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x64,0x64,0x64,0x64,0xA4,0xA5,0xAD,0xAD,0xAD,0x5B,0x64,0x5B,0x5B,0x5B,0xEB,0xF5,0xA4,0xA4,0x64,0x5B,0x5B,0x63,0x63,0x5B,0x5B,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x65,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xA4,0xA4,0xAC,0xED,0xF6,0xAD,0xA4,0xA4,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0x5B,0x5C,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x64,0xA4,0xA5,0xA5,0xA5,0xAD,0x5B,0x5B,0x5B,0x5B,0x5B,0xEC,0xFE,0xA4,0xB6,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5B,0x64,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x64,0x64,0xA5,0xAD,0x65,0x64,0x65,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xA4,0xAC,0xED,0xAD,0xA4,0xA4,0xA4,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xA5,0xAD,0xA5,0x65,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0x65,0xA5,0xA4,0x64,0x64,0x64,0xA5,0xA4,0xAC,0x5B,0x5B,0x5B,0x5A,0x5B,0xAC,0xB5,0x63,0x5B,0x5B,0x5B,0x5B,0xA3,0x63,0xA3,0xFE,0x64,0x5B,0x5B,0x5B,0x63,0x5B,0x5B,0x5B,0xA4,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0x64,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xA4,0xAD,0xAD,0xA4,0xA4,0xA4,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xA5,0xA5,0x65,0x64,0x64,0xAC,0xAD,0x63,0x5B,0x5B,0x5B,0xA3,0xAC,0x5B,0x5B,0x5A,0x5A,0x5A,0x63,0x63,0x5B,0xAD,0x64,0x5B,0x5B,0x5A,0xAC,0x5B,0xA4,0x5B,0x5B,0x64,0x63,0x63,0xA4,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x64,0x64,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xA4,0xA4,0xA4,0xA4,0xA4,0x5B,0x53,0x5B,0x5C,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0x64,0xA4,0xAC,0xAC,0xAC,0xA4,0xA4,0xA4,0xA3,0xA3,0xA3,0x5B,0x5A,0x5A,0x5A,0xA3,0x5B,0x5A,0x5A,0x5B,0x5B,0x5B,0x5B,0x63,0xA3,0xB6,0x5B,0x5B,0x5B,0x63,0xA3,0xA4,0x5B,0x5B,0x5B,0xA4,0x63,0x64,0xAC,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0xA4,0xA4,0xA4,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0x64,0x64,0xAD,0xAD,0xA5,0x64,0xA4,0xAD,0xA4,0xA4,0x63,0x5B,0x5B,0xA4,0xF5,0xAD,0x63,0x5B,0x5A,0xA3,0xF5,0x63,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x63,0x5A,0x5A,0x5B,0x5B,0x5B,0xA3,0xF5,0xAC,0xAD,0x5C,0x5B,0x5B,0x63,0xA3,0xAC,0x64,0x64,0xA4,0xF6,0xA4,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xA4,0xA4,0xA4,0x5C,0x5B,0x5B,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0x64,0x64,0x64,0x64,0xAC,0xB5,0x64,0x5B,0x5B,0xA3,0xAC,0xAC,0xEC,0xAC,0xAC,0xAC,0xB5,0x5B,0x5A,0x5A,0x5A,0x5A,0xA3,0xA4,0x5A,0x5A,0x5A,0x5A,0x5B,0xAB,0xF5,0xA4,0x5B,0x5B,0x63,0x5B,0x5B,0xA3,0xA4,0xA4,0x5C,0xA4,0xFE,0xA4,0x5B,0x63,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0xA5,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xA4,0xA4,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xA5,0x64,0x64,0x64,0x64,0x64,0xA4,0xAD,0xA4,0x63,0xAC,0xAC,0xAC,0xF4,0xF5,0xF5,0xAC,0xAC,0xF5,0xAC,0xA3,0xA3,0xAB,0xF4,0xAC,0x5B,0x5A,0x5A,0x5A,0x5A,0xF4,0xB5,0x5B,0x5A,0x5A,0x5B,0x5B,0xA3,0xF5,0xAC,0xAD,0x5B,0x63,0xA4,0xA4,0x5B,0x5B,0x5C,0x64,0x64,0x63,0xA4,0x63,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x64,0xA5,0x64,0x64,0x65,0xA5,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xAD,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xA4,0x5B,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5C,0x5C,0x64,0x64,0x65,0x65,0x65,0x64,0x65,0x65,0x65,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x64,0x64,0xA4,0xAD,0xA5,0x64,0x63,0xA3,0xAC,0xAC,0xAC,0xF5,0xF5,0xAD,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xA3,0xA3,0xA3,0xF5,0xB5,0x5B,0x5B,0x5B,0x5A,0x5B,0xAC,0xB5,0x5B,0x5A,0x5B,0x5B,0xAC,0xAC,0x5B,0xF6,0x5B,0x5B,0x5B,0x5B,0x63,0x5B,0x63,0x64,0x5B,0x5B,0x63,0x64,0xA4,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x64,0x65,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x64,0x64,0x64,0xA4,0xAD,0xAD,0xAD,0xAD,0x64,0x63,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xF5,0xAC,0x5B,0x5A,0x5A,0xA3,0xF5,0xAC,0x5B,0x5A,0x5A,0x5A,0xAC,0x63,0x5A,0x5B,0x5B,0x5B,0x5B,0x5B,0x63,0xA4,0xAD,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0xA4,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xA5,0x64,0xA5,0xA5,0xAD,0xA5,0xA5,0x64,0x64,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x64,0x64,0x65,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x5B,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xAD,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x64,0x64,0x64,0xA5,0xA5,0xAD,0xAD,0xAD,0x64,0x63,0xAC,0xAC,0xF5,0xAD,0xEC,0xF5,0xF5,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xAC,0xAC,0xF5,0xF5,0x5B,0x5B,0x5A,0x5B,0xF5,0xA4,0x5A,0x5A,0x5A,0x5A,0x5B,0xAC,0xA4,0xA4,0xA4,0x63,0x63,0x5B,0x63,0x5B,0xA4,0x63,0x5B,0x5B,0x5B,0x63,0x63,0x5B,0x64,0xA4,0xAD,0xA4,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0x65,0x65,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0x64,0x65,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0x64,0x64,0x64,0xA5,0x65,0xA5,0xAD,0xAD,0x64,0xA3,0xAD,0xB5,0xF5,0xB5,0xAC,0xF4,0xF5,0xB5,0xAC,0xAC,0xB5,0xB4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xA4,0xAC,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xA3,0xAC,0xA4,0x5B,0x5A,0x5A,0x5A,0x5A,0xA3,0x5B,0x5B,0x5B,0x5B,0x5B,0x63,0xAC,0x5B,0xAD,0x5B,0x5B,0x5B,0x5B,0x63,0x5B,0xA4,0x5C,0x5B,0x5B,0xAC,0xA4,0xA3,0x64,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA4,0x64,0xA5,0xA5,0xA4,0x64,0x64,0x64,0x64,0xA4,0x64,0xA5,0xA5,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xF5,0xAD,0x64,0x64,0x64,0xA4,0xA4,0xA5,0x64,0x63,0xAC,0xB5,0xF5,0xB5,0xF5,0xAC,0xAC,0xAD,0xAD,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xB5,0xF5,0xF5,0xAD,0xAC,0xF5,0xAC,0xAC,0xF5,0xF5,0xB5,0xAC,0xAC,0xAC,0xF5,0xF5,0xB5,0xAC,0xAC,0xAC,0x5B,0x5B,0x5A,0xA3,0xAC,0xF5,0x63,0x5B,0x5B,0x63,0x5B,0x5B,0x63,0x5A,0x5A,0x5A,0x5B,0x5B,0x5B,0xF5,0xA3,0xAD,0x5B,0x63,0xA3,0xA4,0xA3,0xA3,0x5B,0x5B,0x63,0xA4,0xA3,0xA4,0x64,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x64,0xA4,0xA5,0xA4,0x64,0x64,0x64,0x64,0x64,0x64,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xF5,0xB5,0xAD,0x64,0x64,0x64,0x64,0x64,0x64,0xA4,0xAC,0xF5,0xF5,0xAC,0xF5,0xF5,0xB5,0xAC,0xAC,0xAC,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAD,0xA4,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0x63,0x5B,0xA4,0xF5,0xAC,0xAC,0x63,0x5B,0x5B,0x5B,0xAC,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5B,0xA3,0x5A,0x5A,0x5B,0x63,0xA4,0xAC,0xAC,0xF5,0xF5,0x5B,0x5B,0x5B,0xAC,0xEC,0x5B,0x64,0x5C,0xAD,0xAC,0x63,0xA4,0x64,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA4,0x64,0x64,0x64,0x64,0x64,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0x64,0x64,0x65,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5C,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xB5,0xAD,0xAC,0xAD,0xAC,0xA4,0xA4,0xAC,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xB4,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xA3,0xAC,0xA4,0xA4,0xA3,0xA3,0xAC,0xAC,0xF5,0xAC,0x5B,0x5A,0x5A,0x5A,0x5B,0xAC,0xAC,0x5A,0x5A,0x5A,0x5A,0xAC,0xF5,0xAC,0x5B,0xA4,0x5B,0x5B,0x5B,0xF5,0xEC,0xF5,0xA4,0x5B,0x5B,0xA4,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0xA4,0xA4,0xA5,0xA5,0xA4,0xA4,0xA5,0x64,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5C,0x5C,0x5B,0x5B,0x5C,0x5C,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xF6,0xB6,0xB5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xB4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xAC,0xAC,0xF5,0xF5,0xAC,0xA4,0xA3,0xAC,0xF4,0xF5,0xF5,0xA3,0x5A,0x5A,0x5A,0xF5,0xF5,0xA3,0x5B,0x5A,0x5A,0x5B,0xAC,0xF5,0xAC,0xAD,0x5B,0x5B,0xA3,0xAC,0x5B,0x63,0xA4,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0xA4,0xAD,0xA4,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xFF,0xBF,0xBF,0xBF,0xB6,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xB4,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xAC,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xF5,0xAC,0xAC,0x5A,0x5A,0x5A,0x5A,0xF5,0xF5,0xA3,0x5A,0x5A,0x5B,0xAC,0xA4,0x5B,0xAC,0xAD,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0xA4,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xBF,0xB7,0x5C,0xA4,0xBE,0xAD,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xEC,0xAC,0xAC,0xA3,0xAB,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xF5,0x5A,0x5A,0x5B,0xAC,0xF5,0xF5,0xA3,0x5A,0x5A,0x5B,0xAC,0x5B,0x5A,0x5A,0x5A,0x5A,0x5A,0x5B,0x5B,0xA4,0xB5,0xAC,0x5B,0x5B,0xA3,0xA3,0x5A,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0x64,0xA4,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0x65,0x64,0x65,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xB6,0xFF,0xBF,0xB6,0xA4,0xAD,0xBE,0xB6,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xA3,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xF4,0xF4,0xF5,0xF5,0xF5,0xF4,0xF4,0xEC,0xF5,0xAC,0xAC,0xEC,0xF5,0xF5,0xAC,0xA3,0xA3,0xA3,0xAC,0xAC,0xAC,0xA3,0xA3,0xA4,0xF5,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xAC,0xA3,0x5A,0x5A,0x5A,0x5B,0xAD,0xAC,0x63,0xF6,0xA3,0x5B,0x5A,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x63,0xA4,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0x65,0xAD,0xAD,0xAD,0xA5,0xAD,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0x65,0x65,0xA5,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xB6,0xB6,0xBF,0xFF,0xB6,0xF6,0xBF,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xF5,0xF5,0xF5,0xB4,0xAC,0xAC,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xAC,0xA3,0xA3,0xAC,0xA3,0xA3,0xA3,0xAC,0xAC,0xF5,0xF5,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5B,0xF5,0xA3,0x5A,0x5A,0x5A,0x63,0xF5,0xAC,0x5A,0xA4,0x5A,0x5B,0x5A,0x5B,0xA3,0x5B,0xF6,0xA3,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0xAD,0xA3,0xA4,0xA4,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0x65,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xA5,0xAD,0xAE,0xAD,0xAD,0xAD,0xB5,0xAD,0xAC,0xAC,0xAD,0xAD,0xA4,0xAC,0xF4,0xF5,0xF5,0xF5,0xAC,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xA3,0xEC,0xF5,0xF5,0xF4,0xF5,0xEC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xAC,0xA3,0xA3,0xA3,0xA4,0xA3,0xAC,0xAC,0x5A,0x5A,0x5A,0x5A,0x5B,0xAC,0xAC,0xA3,0x5A,0x5A,0x5B,0xAC,0xF5,0xEC,0x5A,0x5A,0x5A,0x5A,0x5A,0xA3,0x63,0x5B,0xAC,0x5A,0x5B,0x5A,0x5B,0xA3,0x63,0xAC,0x5B,0x5B,0x63,0xAC,0xAC,0xA3,0x5C,0x64,0x5C,0x5B,0x64,0x64,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0x65,0x65,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xB5,0xAD,0xAC,0xAC,0xF5,0xB5,0xAC,0xA3,0xAC,0xF5,0xF5,0xF5,0xAC,0xF4,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xEC,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xF4,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xAC,0xEC,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xAC,0x5B,0x5A,0x5B,0x5A,0x5B,0xF5,0x5A,0x5A,0x5A,0x5A,0x5B,0x5A,0xAC,0xA3,0xA4,0xA4,0x5B,0x5B,0xAC,0xF4,0xA3,0x5B,0xA4,0xA4,0x5B,0x5B,0x5B,0x63,0x5B,0x5C,0x64,0x64,0x64,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5C,0x5D,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xF6,0xFF,0xBF,0xB6,0xB6,0xAD,0xAC,0xAC,0xA3,0xAC,0xAC,0xB5,0xB5,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF6,0xF6,0xF5,0xAD,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xAC,0xAC,0xAC,0xEC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xA3,0x63,0x63,0xA4,0xA3,0xA3,0xAC,0xAC,0xA3,0xA3,0xA3,0xAC,0xA3,0xAC,0xA3,0xAC,0xAC,0xB4,0xF5,0xAC,0xAC,0xAC,0xA3,0x5B,0x5A,0x5B,0xAC,0xF5,0xA3,0x5A,0x5B,0x5A,0x5A,0x5B,0xF5,0xA3,0x5B,0x5A,0x5B,0x5B,0xB5,0xFD,0xEC,0xAC,0xF5,0x9B,0x5B,0x5B,0x5B,0x5B,0x5B,0xAD,0xA4,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5C,0x5C,0x5D,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x52,0x52,0x53,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xFF,0xBF,0xB6,0xAD,0xFF,0xBF,0xAC,0xAC,0xAC,0xA4,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF6,0xFE,0xFE,0xFE,0xFF,0xF6,0xA4,0xEC,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xEC,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xEC,0xAC,0xA3,0xEC,0xF5,0xF5,0xF5,0xF5,0xEC,0xF4,0xF4,0xAC,0xAB,0xAC,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xAC,0xA3,0xA4,0xAC,0xAC,0xAC,0xA3,0xAC,0xA3,0xAC,0xA4,0xA4,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xA3,0x5A,0x5A,0x5B,0xF5,0xF5,0xAC,0x5B,0x5B,0x5B,0x5B,0xB5,0xF5,0xAB,0x5B,0x5B,0x5A,0x5A,0x5A,0x64,0xA3,0x64,0xF6,0x9B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0x5B,0x5B,0x5B,0x5C,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5D,0x5C,0x5D,0x65,0x65,0x5C,0x5B,0x53,0x53,0x53,0x52,0x53,0x52,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0x65,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xFF,0xBF,0x5C,0xAD,0xF5,0xBF,0xB5,0xAC,0xB5,0xAC,0xAC,0xA3,0xA3,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xFE,0xFE,0xFF,0xFE,0xFE,0xFF,0x5B,0xEC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xF5,0xF5,0xF4,0xB5,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xA3,0xAC,0xA3,0xA3,0xAC,0xAC,0xA3,0xA4,0xA4,0xA3,0xA4,0xAC,0xAC,0xA3,0xAC,0xA3,0xAC,0xAC,0xAC,0xA3,0xAC,0xAC,0xAC,0xF5,0xAC,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xA3,0x5B,0x5B,0xA4,0xF5,0xF4,0xAD,0x63,0x5B,0x5A,0x5B,0x5A,0x5B,0x5B,0x5A,0x5A,0x5A,0x5B,0x5B,0x5B,0xAC,0x5B,0xB6,0xED,0x5B,0x5B,0x5C,0x5C,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x5D,0x5D,0x65,0x5C,0x5C,0x5C,0x53,0x53,0x52,0x53,0x53,0x52,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xF6,0xFF,0xFF,0xBF,0xA5,0xAD,0xFE,0xB6,0xAD,0xAC,0xF5,0xF5,0xB5,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xB5,0xFF,0xFF,0xFF,0xFF,0xFF,0xF6,0xA3,0xF4,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xA3,0xAC,0xB5,0xA3,0xA3,0xAC,0xAB,0xA4,0xAC,0xF5,0xAC,0xA4,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xA3,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xFD,0xF5,0xF5,0xAC,0xAC,0xAC,0xF5,0xF5,0xEC,0xAC,0xAC,0xAC,0xAC,0xB6,0xFF,0xF6,0xA3,0x5B,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5B,0xA4,0xA3,0x5B,0x5B,0x5C,0x5C,0x65,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5C,0x5D,0x65,0x65,0x5C,0x5C,0x5C,0x53,0x53,0x52,0x53,0x53,0x52,0x52,0x53,0x53,0x5B,0x5C,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAC,0xB5,0xB6,0xB6,0xFF,0xFF,0xFF,0xB5,0xB5,0xAC,0xAC,0xB5,0xB5,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xFF,0xFF,0xFF,0xFF,0xFF,0xB5,0xA3,0xF5,0xF5,0xF5,0xF4,0xAC,0xF5,0xF5,0xF5,0xF5,0xA3,0x5A,0x5A,0xA3,0xA4,0xAC,0xAC,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xF5,0xAD,0xA3,0xB4,0xF5,0xAC,0xA3,0xAC,0xF5,0xA4,0xA3,0xA3,0xAC,0xA4,0xAD,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAD,0xA3,0x5B,0x5A,0x5A,0x5A,0x5A,0x5B,0xAC,0xA3,0x5A,0x5B,0x5B,0x5B,0x5B,0x64,0x5C,0x64,0x65,0xA5,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x5D,0x5D,0x65,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xF5,0xB5,0xF5,0xF5,0xF5,0xAD,0xAD,0xF5,0xF5,0xF5,0xAC,0xAC,0xF5,0xB4,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xFF,0xFF,0xFF,0xFF,0xFF,0xAD,0xA3,0xA3,0xAB,0xAB,0xA4,0xA3,0xAC,0xF5,0xF5,0xAC,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xA3,0xA4,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xA3,0xAC,0xAC,0xA4,0xA3,0xAC,0xAC,0xA3,0xA3,0xA3,0xA3,0xAC,0xA3,0xA3,0xA3,0xA3,0xA3,0xAC,0xA3,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xF4,0xAC,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA4,0xAD,0xAC,0x9B,0x5A,0x5A,0x5B,0xA4,0xAC,0xAC,0x5A,0x5B,0x5B,0x5B,0x63,0x64,0x5B,0x65,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0x65,0x65,0xA5,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xF6,0xB5,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xB5,0xAC,0xEC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xB5,0xF6,0xFE,0xFF,0xFE,0xFF,0xFF,0x63,0xF5,0xAC,0xAC,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xA3,0xA3,0xAC,0xAC,0xF5,0xF5,0xA3,0xA3,0xA3,0xAC,0xAC,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5B,0xA3,0xA4,0xAC,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xAC,0xEC,0xAC,0xEC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA4,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xAC,0xF5,0xAC,0xAC,0xAC,0xA4,0xB5,0xAC,0xAD,0xF5,0xF5,0xEC,0xAC,0xAC,0xB5,0xAC,0xAC,0xAC,0xA3,0x5B,0xAD,0xAC,0x5B,0x5B,0x65,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xFF,0xFF,0xBF,0xBF,0xB6,0xAC,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAB,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAD,0xB5,0xF6,0xFE,0xFE,0xB6,0xA3,0xF5,0xAC,0xF4,0xF4,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xA4,0xF5,0xAC,0xAC,0xAC,0xAC,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xA3,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xF5,0xF5,0xFE,0xFE,0xFE,0xFE,0xF5,0xF5,0xEC,0xF4,0xAC,0xAC,0xAC,0xAC,0xAC,0xAD,0xF5,0xA3,0x5B,0x5B,0x5B,0xAD,0xAC,0xAD,0xF5,0xF5,0xF5,0xEC,0xF5,0xAC,0xAC,0xB5,0xF5,0xF5,0xAC,0xAD,0xB5,0xAD,0xAC,0xAC,0xA3,0x5B,0x5C,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0xA5,0xAD,0xAD,0xAD,0xAE,0xAD,0xA5,0xA5,0xF6,0xBF,0x6E,0x64,0xB6,0xB6,0xEC,0xF5,0xF5,0xB5,0xB4,0xAC,0xAC,0xAC,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0x5A,0x5A,0x5B,0x5B,0xA4,0x64,0xA3,0xAC,0xA4,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0x5B,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xAC,0xF5,0xF4,0xAC,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xA4,0xAC,0x63,0xA3,0xF5,0xF5,0xF5,0xF4,0xF6,0xF5,0xFE,0xFE,0xF5,0xF6,0xFE,0xFF,0xFF,0xFE,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xA3,0xAD,0xFF,0xFF,0xA4,0x63,0xAD,0xF5,0xF5,0xED,0xF5,0xAD,0xF5,0xF5,0xF5,0xF5,0xA3,0x5B,0x5B,0x5B,0x5B,0xAC,0xF5,0xF5,0x9B,0x5B,0x64,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0xAD,0xA5,0x65,0x65,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x66,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x64,0xA5,0xAD,0xAD,0xAD,0xB6,0xFF,0xBF,0x64,0xAD,0xAD,0xBF,0xA4,0xAC,0xAC,0xAC,0xB4,0xAD,0xAC,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF4,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xF5,0xAC,0xA3,0x5B,0xF5,0xA4,0xA3,0xAC,0xA3,0xA3,0xAC,0xAC,0xA3,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xAC,0xF5,0xF5,0xEC,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xA4,0xA3,0xAC,0xAC,0xF5,0xF5,0xF5,0xF4,0xFF,0xFF,0xF6,0xED,0xAD,0xF5,0xB5,0xAD,0xF5,0xFE,0xF5,0xF5,0xA4,0xF5,0xF5,0xF5,0xF5,0xA3,0xB6,0xFF,0xFF,0xAD,0xA4,0xF5,0xF5,0xF5,0xED,0xF5,0xF5,0xAC,0xF5,0xEC,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0xAC,0x5B,0x5B,0x65,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0xA5,0xA5,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0xA5,0x65,0x65,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x65,0x65,0x65,0x65,0x64,0x5C,0x53,0x53,0x53,0x53,0x53,0x52,0x53,0x53,0x5B,0x5C,0x5C,0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x64,0x64,0x64,0xA5,0xB6,0xFF,0xFF,0xBF,0xB6,0xB6,0xFF,0xB6,0xAC,0xAC,0xA3,0xA3,0xA3,0xA3,0xAC,0xAC,0xAC,0xF4,0xF4,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF4,0xF4,0xF4,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xF5,0xAC,0xF5,0xF4,0xA3,0xAC,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xA3,0xAC,0xAC,0xAC,0xAC,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xAC,0xAC,0xAB,0xF5,0xF5,0xF5,0xF5,0xF5,0xF6,0xFE,0xEC,0xED,0xED,0xED,0xF5,0xED,0xAD,0xAD,0xFE,0xF5,0xA3,0xAD,0xAC,0xF5,0xF5,0xA3,0x64,0xB6,0xB6,0x63,0xAD,0xF5,0xF5,0xF5,0xF5,0xFE,0xF5,0xAD,0xF5,0x9B,0x5B,0x5B,0x5B,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xAE,0xAE,0x6E,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0x64,0x65,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0x65,0x65,0x64,0x64,0x64,0xA3,0xA3,0xAC,0xAD,0xB6,0xB6,0xB5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xA3,0xAB,0xF4,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF4,0xF4,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xF4,0xA3,0xA3,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xA3,0xAC,0xAC,0xAC,0xAB,0xA3,0xA3,0x63,0x5B,0x5A,0x5A,0x5A,0x5A,0xA3,0xAC,0xF4,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xFE,0xF5,0xAC,0xED,0xED,0xF5,0xF5,0xED,0xAD,0xAC,0xFE,0xFD,0xA3,0xB6,0xF5,0xF5,0xF5,0xF5,0xA3,0x5B,0x5B,0xA4,0xF5,0xF5,0xF5,0xF5,0xAD,0xF5,0xAC,0xAD,0xEC,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0x64,0x64,0x5B,0x64,0xAD,0x64,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xAE,0xAE,0xAE,0xAE,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAD,0xA5,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0x65,0x64,0x64,0x64,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xF4,0xF5,0xF5,0xF4,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF4,0xF5,0xF4,0xF4,0xF4,0xF4,0xF5,0xF4,0xF5,0xF5,0xF5,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xA3,0xA3,0xAC,0xAC,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xA3,0xAC,0xAC,0xAC,0xA3,0xA3,0xA3,0xA3,0xA3,0xAC,0xA3,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xFF,0xFE,0xAC,0xAD,0xAD,0xED,0xED,0xED,0xAC,0xA4,0xFE,0xF5,0x9B,0xAD,0xEC,0xF5,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xB5,0xAD,0xAC,0xF5,0xAB,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x63,0x64,0xAC,0x5B,0x5C,0x64,0x64,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0xAE,0xAE,0xAE,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0x65,0x65,0xA4,0xAC,0x63,0x63,0x5B,0x5B,0x5B,0x63,0x63,0xA3,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAB,0xEC,0xF4,0xF5,0xF5,0xF5,0xF4,0xF4,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF4,0xF4,0xF4,0xF5,0xF4,0xF5,0xF5,0xF5,0xF4,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xB4,0xAB,0xAC,0xF5,0xAC,0xAC,0xAC,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xAC,0xA3,0xA3,0xAC,0xF5,0xF5,0xAC,0xAC,0xAC,0xA3,0xA3,0xA3,0xA3,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xF5,0xFE,0xEC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA4,0xFF,0xEB,0x5B,0xAC,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0x5B,0xAC,0xAC,0xAC,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x63,0x6C,0xAC,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0xAE,0xAE,0x65,0x65,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0x65,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0x65,0x65,0x65,0x65,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xA5,0xA5,0xAD,0x64,0x63,0x63,0x63,0x63,0x5B,0x5B,0x63,0xA3,0xA3,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xF5,0xEC,0xF5,0xF5,0xF5,0xF4,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF4,0xF5,0xF4,0xF4,0xF4,0xF4,0xF5,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xA3,0xA4,0xA3,0xA3,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5B,0xA3,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF6,0xED,0xF6,0xFF,0xF5,0xAC,0xA3,0xA3,0xA3,0xA4,0xF6,0xFE,0xA3,0x5B,0xAC,0xA3,0xF5,0xF5,0xF4,0xA3,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAD,0xF5,0xAC,0xA3,0x63,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0x63,0xAD,0xA3,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x64,0x5C,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xAE,0x66,0x65,0x65,0x65,0x65,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0x65,0x65,0x65,0x65,0x65,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x64,0x64,0x5B,0x5B,0x64,0x63,0x63,0xA4,0xA3,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xB5,0xAB,0xAC,0xAB,0xAC,0xAC,0xF4,0xF4,0xF4,0xF5,0xF5,0xF5,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF5,0xF4,0xF5,0xF4,0xF5,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xA3,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x52,0x5B,0xAC,0xAC,0xA3,0xA4,0xA3,0xAC,0xF5,0xF5,0xAC,0xAC,0xAC,0xAB,0xAC,0xEC,0xF5,0xF5,0xF5,0xF5,0xF4,0xF4,0xAC,0xEC,0x5A,0xA4,0xF5,0xFE,0xFF,0xFF,0xFE,0xFE,0xFE,0xF5,0xEC,0xA3,0xA3,0xAC,0xAC,0xF5,0xF5,0xEC,0xAC,0xB5,0xAC,0xF5,0xF5,0xF4,0xAC,0xF5,0xAD,0xF5,0xF5,0xEC,0xAC,0xA4,0xA3,0x63,0x63,0x5B,0x63,0x63,0x63,0xAC,0xF5,0x9B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x64,0x64,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x6E,0xAE,0xAE,0x65,0x65,0x64,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x64,0x64,0x64,0xA5,0xA5,0xAD,0xA5,0x64,0x63,0xA4,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xA3,0xA3,0xA3,0xAC,0xAC,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF5,0xF4,0xF4,0xF5,0xF5,0xF5,0xF4,0xF4,0xF4,0xF4,0xAC,0xF4,0xF4,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xAB,0xAC,0xAC,0xA3,0xAC,0x5B,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x52,0xA3,0xA3,0xAC,0xF4,0xAC,0xAC,0xAC,0xB4,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xAB,0xAC,0xA3,0xAC,0xF5,0xF5,0xA3,0x5A,0x5A,0x5B,0x5B,0xA3,0xAC,0xF5,0xF5,0xAC,0xAC,0xA4,0xF6,0xEC,0xAC,0xF5,0xF5,0xEC,0xAC,0xF5,0xAC,0xAC,0xF5,0xF5,0xF5,0xFF,0xFE,0xEC,0xED,0xF5,0xF6,0xF6,0xF5,0xF5,0xAD,0xAC,0xA4,0xA3,0xAC,0xF6,0xF4,0x9B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x65,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xAE,0xAE,0xAE,0xAE,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x65,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0x65,0x65,0x65,0x64,0x64,0x64,0x64,0xAD,0xAD,0xAD,0xAD,0xAD,0x64,0x63,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xAC,0xAC,0xA3,0xAB,0xAC,0xAC,0xA3,0xA3,0xA3,0xAB,0xAC,0xAC,0xAC,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xB4,0xF4,0xF4,0xF4,0xF4,0xF4,0xB4,0xF4,0xF4,0xF5,0xF5,0xF4,0xF4,0xF4,0xAC,0xAB,0xAC,0xAC,0xAC,0xA3,0xAC,0xAC,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xAC,0xAC,0xAC,0xA3,0xA3,0xA3,0xAB,0xAC,0xF5,0xF5,0xF4,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF4,0xAC,0xAB,0xA3,0x5B,0x5A,0x5A,0x5A,0x5A,0x5A,0x5B,0x5B,0x5B,0x5B,0xA3,0xFE,0xF5,0xF4,0xAC,0xF5,0xAC,0xAD,0xF5,0xEC,0xAC,0xF5,0xF5,0xF5,0xFF,0xFD,0xE3,0x9B,0xA4,0xAD,0xFE,0xFE,0xFE,0xF6,0xF6,0xF6,0xF5,0xF5,0xED,0xEC,0xA4,0xAD,0xA4,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x5C,0x5C,0x64,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xAE,0xAE,0xAE,0xAE,0x65,0x64,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0x65,0x64,0x64,0x64,0x64,0xAD,0xAD,0xAE,0xAD,0xAD,0x64,0x63,0xAC,0xAC,0xF5,0xF5,0xAC,0x5B,0x5A,0x5B,0xAC,0xF4,0xF5,0xAC,0xAC,0xAC,0xA3,0xAC,0xAC,0xAC,0xAB,0xA3,0xA3,0xA3,0xA3,0xAB,0xAB,0xAC,0xAC,0xF4,0xF4,0xB4,0xAC,0xB4,0xF4,0xF4,0xF4,0xF4,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xF4,0xAC,0xAC,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5B,0xAC,0xAC,0xAC,0xF4,0xAC,0xA3,0xAC,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAB,0xAC,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xA3,0x5A,0x5B,0x5A,0x5A,0x5A,0x5A,0x5B,0xAC,0xF5,0xF5,0xEC,0xA3,0xAC,0xAC,0xEC,0xAC,0xAC,0xF5,0xF5,0xF6,0xFE,0xF5,0xA3,0xA3,0xA4,0xAD,0xFE,0xF6,0xF6,0xF5,0xF5,0xF5,0xF5,0xF6,0xFE,0xFE,0xF5,0xA3,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x5C,0x5C,0x64,0x65,0x65,0x64,0x65,0xAD,0xAD,0xAD,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x6E,0xAE,0xAE,0x6E,0x65,0x65,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0x65,0xA5,0xA5,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0xAD,0xAE,0xAE,0xAE,0xAD,0x65,0x64,0x64,0x64,0xA4,0xAD,0xAD,0xAD,0xAD,0x64,0x63,0xA3,0xAC,0xB5,0xB5,0xAC,0x5B,0xB5,0xB6,0x64,0x9A,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xA3,0xAC,0xAB,0xA3,0xA3,0xAB,0xA3,0xA3,0xA3,0xAB,0xAB,0xAC,0xAC,0xAC,0xF4,0xF4,0xF4,0xF4,0xAC,0xF5,0xAC,0xAB,0xAC,0xAC,0xAC,0xF4,0xAC,0xF4,0xAC,0xAC,0xA4,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x52,0xA3,0xAC,0xAC,0xAC,0xA3,0xA3,0xF4,0xF4,0xAC,0xAB,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF4,0xAC,0xAC,0xAC,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xA3,0xA3,0xA3,0xB5,0xF5,0xF5,0xF5,0xAC,0xA3,0xAD,0xAB,0x5A,0xA3,0xAC,0xF5,0xF6,0xEB,0xA4,0xA3,0xA4,0xA4,0xF6,0xFE,0xF6,0xFE,0xE3,0xA4,0xA4,0xA4,0xA4,0xF6,0xFE,0xF5,0xED,0x9B,0x5B,0x5B,0x5B,0x5C,0x64,0x5C,0x5C,0x5C,0x64,0x65,0xA5,0x65,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x6E,0xAE,0x6E,0x65,0x64,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAD,0xAD,0x65,0x65,0x65,0x65,0xAD,0xAD,0x65,0x64,0xA4,0x6C,0x64,0x64,0xA4,0xAD,0xAD,0x64,0x64,0xA3,0xEC,0xF5,0xF5,0xB5,0x64,0xAD,0xFF,0xBF,0xB6,0x5A,0xAC,0xF4,0xF5,0xF5,0xF5,0xF4,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xA3,0xA3,0xAB,0xA3,0xAB,0xAB,0xA3,0xA3,0xA3,0xAB,0xAB,0xA3,0xAC,0xA3,0xAB,0xAC,0xAC,0xAC,0xAC,0xF5,0xF4,0xA3,0xAC,0xF4,0xB4,0x5B,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x52,0xA3,0xAC,0xF4,0xAC,0xAC,0xAC,0xAC,0xAC,0xF4,0xF5,0xF5,0xAC,0xAB,0xA3,0xAB,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xB5,0xFE,0xF5,0xAC,0xAC,0xA3,0xAD,0xFE,0xFE,0xF6,0xFE,0xEC,0xA4,0xA4,0xA3,0xA4,0xB5,0xFE,0xF5,0xF5,0x9B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x65,0xA5,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x6E,0x66,0x6E,0x6E,0x65,0x65,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0x65,0x65,0x65,0xA5,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x65,0x65,0x64,0x64,0x64,0x64,0xAC,0xB5,0xAD,0x64,0x64,0x64,0x64,0x63,0xA3,0xF5,0xF5,0xF5,0xB5,0xAC,0x63,0xA4,0xFF,0xBF,0x6D,0xA3,0xF4,0xF4,0xF5,0xF5,0xF5,0xF5,0xB4,0xF4,0xB4,0xB4,0xAC,0xA3,0xAB,0xAC,0xAC,0xB4,0xF5,0xAC,0xAC,0xAC,0xAB,0xA3,0xAB,0xAB,0xA3,0xAB,0xA3,0xA3,0xA3,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF4,0xF4,0xF4,0xAC,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xAC,0xAC,0xAC,0xAC,0xA3,0xAC,0xF5,0xF5,0xF5,0xF4,0xAB,0xF4,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAB,0xAC,0xF4,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xAC,0xAC,0xF4,0xF4,0xF5,0xF5,0xF5,0xFD,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xF5,0xF4,0xAC,0xAD,0xF5,0xF5,0xF5,0xF5,0xF6,0xFE,0xFE,0xFE,0xF6,0xFE,0xFE,0xF5,0xAC,0xB5,0xF6,0xF6,0xED,0xEC,0x9B,0x5B,0x5B,0x5B,0x64,0x64,0xA4,0x64,0x64,0x64,0x65,0xA5,0xA5,0x65,0xA5,0xA5,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x6E,0x6E,0x6E,0x66,0x65,0x65,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0x65,0x65,0x65,0x65,0x64,0xAD,0xAD,0xAD,0xAC,0xB5,0xB5,0xAC,0xAC,0xAC,0xF5,0xF5,0xB5,0xAC,0xAC,0xAC,0xAC,0xAC,0x5A,0x5B,0x5B,0x9B,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAB,0xA3,0xAC,0xAB,0xAB,0xA3,0xA3,0xA3,0xAB,0xAB,0xAC,0xAC,0xF4,0xF4,0xAC,0xAC,0xAB,0xA3,0xAB,0xAC,0xAC,0xF4,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xF5,0xAC,0x5A,0x52,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xF5,0xAC,0xAC,0xAC,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xA3,0xAC,0xAC,0xA3,0xAB,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xEC,0xAC,0xAC,0xAC,0xF4,0xF4,0xF5,0xF5,0xF5,0xFD,0xF5,0xEC,0xF5,0xF5,0xF5,0xF5,0xEC,0xA4,0xFE,0xFE,0xFE,0xF6,0xFE,0xF6,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xF5,0xF5,0xEC,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0xA4,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x6E,0xAE,0x6E,0x65,0x65,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0x65,0xA5,0xAD,0xB6,0xA4,0xAD,0x63,0x5B,0xA3,0xAC,0xAC,0xF5,0xB5,0xAC,0xAC,0xA3,0xA3,0xA3,0xA4,0xAB,0xAC,0xA4,0xAC,0xF5,0xB4,0xAC,0xB4,0xAC,0xF5,0xB4,0xAC,0xAC,0xAB,0xA3,0xAC,0xAC,0xAB,0xAC,0xA3,0xA3,0xAC,0xAC,0xAB,0xAB,0xA3,0xA3,0xA3,0xA3,0xAB,0xAC,0xAC,0xAC,0xAC,0xB4,0xF5,0xF4,0xB4,0xF4,0xF4,0xF5,0xF5,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xAC,0xA4,0xA3,0xA3,0x5A,0x52,0x52,0x52,0x52,0x52,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0xA3,0xAC,0xAC,0x5A,0x5A,0x63,0xA3,0xAB,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xAB,0xAB,0xAB,0xAC,0xAC,0xAC,0xAC,0xAC,0xAB,0xA3,0xAC,0xAC,0xEC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xF4,0xF4,0xF4,0xAC,0xF5,0xAC,0xAC,0xEC,0xA4,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFE,0xFE,0xFE,0xFE,0xF5,0xF5,0xA3,0x5B,0x5B,0x5C,0x5C,0x5C,0x64,0x64,0xA5,0xA5,0xA4,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0x64,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x6E,0x6E,0x6E,0x6E,0x65,0x65,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0x65,0xA5,0xAD,0xAD,0xA4,0xAD,0x5B,0x5A,0x5A,0xA3,0xA3,0xAC,0xAC,0xA3,0xEC,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xA3,0xA3,0xA3,0xA3,0xA3,0xAC,0xA3,0xAC,0xAC,0xAB,0xA3,0xAB,0xAC,0xAC,0xAC,0xAC,0xA3,0xA3,0xAB,0xAC,0xAB,0xAC,0xAC,0xA3,0xAB,0xAC,0xAC,0xAB,0xAB,0xA3,0xA3,0xA3,0xAB,0xAC,0xAC,0xAC,0xB4,0xF4,0xAC,0xAB,0xAC,0xAC,0xAC,0xF5,0xAC,0xAC,0xAC,0xAB,0xAC,0xAC,0xF5,0xAC,0xAC,0xA4,0x5B,0x5A,0x52,0x52,0x52,0x52,0x5A,0x5A,0x52,0x5A,0xAC,0xAD,0xAD,0xAC,0xAC,0xAC,0xEC,0xAC,0xA3,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF4,0xF5,0xAC,0xAB,0xAC,0xB4,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xF4,0xEC,0xAC,0xAC,0xA3,0xAC,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xEC,0xF4,0xF5,0xF5,0xF5,0xF5,0xAC,0xFE,0xFE,0xFE,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFE,0xFE,0xF5,0xF5,0xA3,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x6E,0x6E,0x6E,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0x64,0x65,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0x5C,0x5B,0x5B,0x52,0x52,0x52,0x9A,0xAC,0xA4,0xF5,0xAD,0x5A,0xA2,0xAC,0xAC,0xA4,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xAC,0xAC,0xAB,0xAC,0xAC,0xAC,0xF5,0xF5,0xAC,0xA3,0xAB,0xAB,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAB,0xAC,0xAC,0xAC,0xAB,0xAB,0xA3,0xA3,0xA3,0xA3,0xAB,0xAC,0xAC,0xAC,0xB4,0xAB,0xAB,0xAC,0xAC,0xAC,0xAC,0xA3,0xAC,0xF5,0xF4,0xF5,0xAC,0xAC,0xAC,0xA4,0xA3,0xA3,0x5A,0x52,0x52,0xA3,0xF5,0xA3,0xA4,0xAD,0x5A,0xAC,0xF4,0xAC,0xAC,0xA3,0xA3,0xA3,0xA3,0xAB,0xAC,0xAC,0xAB,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xEC,0xAC,0xF5,0xAC,0xAC,0xF5,0xF5,0xA3,0xAC,0xF4,0xA3,0xAB,0xA3,0xAB,0xA3,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF4,0xAC,0xF5,0xF5,0xF5,0xAC,0xF5,0xAD,0xFE,0xF6,0xFE,0xF6,0xF5,0xF6,0xF6,0xFE,0xFE,0xFE,0xFE,0xF6,0xED,0xED,0xA3,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0x64,0x5C,0x5B,0x5B,0x52,0x52,0x52,0x5A,0xAC,0x64,0x5B,0x5B,0x5A,0x5A,0xA3,0xF5,0xB5,0xED,0xAD,0x5A,0x5A,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xB4,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xAB,0xAC,0xAC,0xAC,0xAC,0xA3,0xAC,0xAC,0xAB,0xAC,0xAC,0xAC,0xAC,0xAC,0xAB,0xAC,0xA3,0xA3,0xAB,0xAC,0xA3,0xA4,0xAC,0xF4,0xAC,0xAC,0xA2,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xA3,0x5A,0x5B,0xA3,0xAC,0xAC,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xA3,0xA3,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xEC,0x9B,0xA3,0xA3,0xA4,0xAC,0xEC,0xF5,0xAC,0xAC,0xA3,0xA3,0xA3,0xAB,0xAB,0xAC,0xAC,0xAC,0xF5,0xF5,0xAC,0xAC,0xAD,0xF5,0xEC,0xF6,0xF6,0xF6,0xF6,0xF6,0xF5,0xF6,0xFE,0xFE,0xF6,0xFE,0xF6,0xF5,0xED,0xEC,0x9B,0x64,0x64,0x64,0x64,0xA5,0xAD,0xA5,0xA5,0xA4,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xAE,0xAE,0x6E,0x6E,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0x65,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x65,0xA5,0xAE,0xAE,0xAE,0xAD,0x6D,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x9A,0xAC,0x53,0x52,0x52,0x52,0x5A,0xA3,0xB5,0x5B,0xAC,0xA4,0x5A,0x5A,0x9A,0xF5,0xF5,0xAC,0xAC,0xA3,0xA3,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xA3,0xA3,0xAC,0xF5,0xF4,0xAC,0xA3,0xA3,0xA3,0xAC,0xAC,0xAC,0xAB,0xAC,0xA3,0xA3,0xAC,0xAC,0xAB,0xAC,0xAC,0xAC,0xAB,0xA3,0xAB,0xAB,0xA3,0xAC,0xAC,0xA3,0xAC,0xAC,0xAC,0xA3,0xA3,0xA3,0xAB,0xAC,0xAC,0xAC,0xEC,0xAC,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xB4,0xF4,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF4,0xAC,0xF5,0xF5,0xF6,0xF6,0xF6,0xA3,0xA3,0xA3,0x5B,0x5B,0x9B,0x5B,0x9B,0x9B,0xA3,0xF5,0xF5,0xAC,0xAC,0xA3,0xA3,0xAC,0xAC,0xAC,0xF5,0xF5,0xEC,0xF5,0xF5,0xF5,0xAC,0xF6,0xFE,0xF6,0xF6,0xFE,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFE,0xF5,0xF5,0xA3,0x9B,0x5B,0x5B,0x5C,0x64,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x66,0x6E,0xAE,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0x65,0x65,0x65,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0xA5,0xAD,0xAD,0xAE,0x6E,0x5C,0x5B,0x5B,0x53,0x52,0x52,0x52,0x9A,0x64,0x52,0x52,0x52,0x52,0x5A,0xAC,0xAC,0x5A,0x52,0x52,0x52,0x5A,0x9A,0xF5,0xAD,0xEC,0xF6,0x5A,0x5A,0x9A,0xAC,0xF5,0xF5,0xA3,0xA3,0xA3,0xF4,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xAB,0xAC,0xAC,0xAC,0xAC,0xA3,0xAB,0xA3,0xAB,0xAB,0xAB,0xAC,0xF5,0xAC,0xA3,0xA3,0xAC,0xF5,0xAC,0xA3,0xAC,0xAC,0xEC,0xAC,0xAC,0xAC,0xF4,0xAC,0xA3,0xF4,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xEC,0xF5,0xF5,0xAC,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xAC,0xF6,0xFE,0xF5,0x5A,0xAC,0xA3,0x5B,0x5B,0x5B,0x5B,0x5B,0x9B,0x5A,0xF5,0xF6,0xF5,0xF5,0xF5,0xF5,0xF4,0xA3,0xAC,0xF5,0xF4,0xEC,0xAC,0xAC,0xAC,0xA3,0xA4,0xF5,0xF6,0xF6,0xF6,0xF6,0xFE,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF5,0xF5,0xA3,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x65,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x66,0x66,0x6E,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x65,0xA5,0xAE,0xAE,0x65,0x5C,0x53,0x52,0x52,0x52,0x52,0xA3,0x5B,0x52,0x52,0x52,0x52,0x52,0x5A,0x5A,0x52,0x52,0x52,0x52,0x5A,0xA2,0xFD,0xAC,0x52,0x52,0x52,0x5A,0x5A,0xEC,0xF5,0xF5,0xAD,0x5A,0x5A,0x9A,0xAC,0xAC,0xA3,0xA3,0xAB,0xF4,0xAC,0xAC,0xAB,0xAC,0xAC,0xAC,0xA3,0xAB,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xAC,0xAC,0xAC,0xA3,0xA3,0xAC,0xF5,0xAC,0xAB,0xA3,0xAB,0xA3,0xAC,0xAC,0xA3,0xAC,0xAC,0xF5,0xAC,0xAC,0xAC,0xF5,0xAC,0xAC,0xA3,0x5A,0xA3,0xA3,0xA4,0xAD,0x5A,0xAC,0xAC,0xB4,0xAC,0xAC,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xF5,0xF5,0xF5,0xF5,0xF6,0xF6,0xF5,0x5A,0xAC,0x9B,0x5B,0x5B,0x5B,0x5B,0x5B,0x9B,0x5B,0xB5,0xF5,0xF5,0xF5,0xA3,0xEC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xEC,0xA3,0xAD,0xF6,0xF6,0xFE,0xFE,0xFE,0xF6,0xF6,0xF6,0xFE,0xFE,0xFE,0xED,0xEC,0x9B,0x5B,0x5B,0x5C,0x64,0x64,0xA4,0xA4,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x6E,0x6E,0x66,0x66,0x66,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0x65,0xA5,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAD,0x65,0x5C,0x5B,0x5B,0x5C,0x5B,0x5A,0x5A,0x5B,0x52,0x52,0x52,0x5A,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0xA2,0xB4,0x5B,0x52,0x52,0x52,0x52,0x52,0xAC,0x63,0x5A,0x5B,0x5A,0x5A,0x5A,0x62,0x5A,0xAD,0xA4,0x5A,0x5A,0xAB,0xAB,0xF5,0xFD,0xF5,0xF5,0xAC,0xAC,0xA3,0xAC,0xAC,0xAB,0xAB,0xAC,0xAC,0xAC,0xA3,0xAC,0xF5,0xF4,0xAC,0xAB,0xAC,0xAC,0xAB,0xA3,0xAC,0xA3,0xAC,0xAC,0x9B,0xEC,0xAC,0xAC,0xAC,0xAC,0x62,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0x5B,0xA3,0xAC,0xF5,0xF5,0xF5,0xAC,0xEC,0xAC,0xF5,0xAC,0xAC,0xED,0xAC,0xED,0xEC,0xF5,0xA3,0xA3,0xAC,0xA3,0x5B,0xA3,0x9B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0xA3,0xF5,0xF5,0xF6,0xF5,0x9A,0xB5,0xAB,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xEC,0xA3,0x9B,0xA3,0xA4,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xFE,0xFE,0xFE,0xFE,0xF5,0xED,0xEC,0x9B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA4,0xA4,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x65,0x65,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0xAE,0x6E,0x66,0x65,0x65,0x65,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0x65,0xA5,0xA5,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0x65,0xA5,0xAD,0xAE,0x65,0x5C,0x5B,0x53,0x52,0x52,0x53,0x5B,0x52,0x52,0x52,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0xA3,0x5A,0x52,0x52,0x52,0x52,0x5A,0x5B,0x52,0xA3,0x5B,0x52,0x52,0xA3,0xF5,0xF5,0xAC,0x5B,0x5A,0x9A,0xA3,0xA3,0xA3,0xA3,0xAC,0xF5,0xA3,0x5A,0xAB,0xF5,0xF5,0xF5,0xAC,0xAC,0xF5,0xF5,0xA3,0xAB,0xAB,0xAC,0xAC,0xF4,0xAC,0xA4,0xF4,0xAC,0xAC,0xAC,0xA3,0xAC,0xAC,0xF5,0xF5,0xAB,0xAC,0xA3,0xAC,0xAB,0xAC,0xAC,0xAB,0xA3,0xAB,0xA3,0xAC,0xA3,0xA4,0xAC,0xAC,0xF5,0xA3,0xF5,0xAC,0xAC,0xA4,0x5A,0x5A,0x5A,0x5B,0xA3,0x9B,0x5B,0x5B,0x9B,0x5B,0x5B,0x5A,0xA4,0xB5,0xF6,0xF6,0xEC,0x5B,0xF5,0xAB,0xAC,0xF5,0xF5,0xF5,0xF6,0xF5,0xF5,0xEC,0x9B,0xA3,0xAD,0xF6,0xF6,0xF6,0xEC,0xA4,0xAC,0xAC,0xF5,0xFE,0xFE,0xF5,0xED,0xA4,0x9B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x6E,0x6E,0x6E,0x6E,0x66,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0xA5,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x65,0xA5,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0x65,0x65,0x5C,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0x5A,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0x52,0x52,0x52,0x52,0x52,0x5A,0xAC,0x52,0x52,0x52,0x52,0x52,0xA3,0xF5,0xA3,0xF5,0xA4,0x5A,0x5A,0xA3,0xF5,0xAC,0xAC,0x5A,0xA3,0xAC,0xAC,0xF5,0xF5,0xF5,0xAC,0xAC,0xF4,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xA4,0xF5,0x5A,0xAC,0xAC,0xAC,0xA3,0xA3,0xA3,0xAC,0xF5,0xF4,0xF5,0xF4,0xAC,0xA3,0xA3,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xA4,0x5A,0x5B,0xA4,0xAC,0xAC,0xF5,0xF5,0xA3,0x5B,0x5B,0xAC,0xAC,0x5A,0x5A,0x5B,0x5B,0x9B,0x9B,0x5A,0x63,0xF6,0xF6,0xF6,0xA3,0xA4,0xF5,0xAC,0xAC,0xF5,0xF5,0xF5,0xFE,0xEC,0xF5,0xF5,0xA3,0xA4,0xF6,0xF6,0xF6,0xF5,0xA3,0x52,0x5A,0x52,0x64,0xF6,0xFE,0xF5,0xF5,0xA3,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0xAE,0x6E,0x66,0x66,0x66,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0x65,0x65,0x65,0xA5,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x65,0xA5,0xAD,0xA5,0xAD,0xA5,0x65,0x53,0x52,0x53,0x5B,0x5B,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0xAC,0xAC,0x52,0x5A,0x5A,0x5A,0x5A,0xA3,0xF5,0xAC,0xAD,0x63,0x5A,0x5A,0xAC,0xAC,0xF4,0xAC,0xAC,0xAC,0xAC,0xAC,0xF4,0xF5,0xAC,0xAC,0xF5,0xF4,0xF4,0xA3,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0xAC,0xA3,0xA3,0xAC,0xAC,0xAC,0xAC,0xF5,0xF4,0xF5,0xA3,0x5A,0x5A,0xAC,0xAC,0xA3,0xAC,0xAC,0xF5,0xAC,0xAC,0xA3,0xAC,0xAC,0xAC,0xF5,0xAC,0xB5,0xF4,0xEC,0xA3,0x5A,0x52,0x5A,0x5A,0x5A,0x5B,0xAC,0x5A,0x5A,0xA3,0x5A,0xAC,0xF4,0xAC,0xAD,0xF5,0xF5,0xF5,0xFF,0xF5,0xEC,0xF5,0xF6,0xF6,0xF6,0xF5,0xF6,0xF5,0xF5,0xA4,0x5B,0x52,0x5B,0xAD,0xFE,0xF5,0xED,0x9B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x6E,0x6E,0x6E,0x66,0x66,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0x64,0x64,0xA5,0xAD,0xA5,0x65,0x5C,0x53,0x52,0x5B,0x5B,0x5B,0x53,0x12,0x12,0x52,0x52,0x52,0x52,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x5A,0x52,0x5A,0x52,0x52,0x5A,0xEC,0xF5,0x5B,0x52,0x5A,0x5A,0x5A,0xAC,0xF5,0xF5,0xF5,0x5A,0x5A,0xEC,0xAC,0xAC,0xF5,0xAC,0xA3,0xF4,0xAB,0xAC,0xA3,0xF5,0xEC,0xAC,0xB4,0xAB,0xAC,0xAC,0xA3,0xA3,0xA3,0xA3,0x5A,0xA4,0x5A,0xAC,0xAC,0xA3,0x5A,0x5B,0x52,0xF5,0xF5,0xF4,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xB4,0xF5,0xF5,0xF5,0xF5,0xF4,0xF4,0xAC,0xAC,0xF5,0xAC,0xAC,0xA4,0x5B,0xAC,0xF5,0x9B,0x5A,0x5A,0x5A,0xAC,0xAC,0xA3,0xB5,0xF5,0xF5,0xF5,0xFF,0xFF,0xEB,0x9B,0xA3,0xA4,0xAC,0xED,0xF5,0xF5,0xF5,0xF6,0xF5,0xAD,0xB5,0xF6,0xF6,0xEC,0xED,0x9B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x66,0x6E,0x6E,0x6E,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0x65,0x64,0x64,0xA5,0xA5,0x65,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x12,0x52,0x5A,0x5A,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0xAC,0xAC,0x5A,0x52,0x52,0x5A,0x5A,0xF4,0xF5,0x5A,0xA3,0x52,0x5A,0x5A,0xF5,0xF5,0xAC,0xA3,0x5A,0xA3,0xAB,0xAC,0xF5,0xF5,0xAC,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAB,0xAC,0xF5,0xAC,0xAC,0xF5,0xAC,0xA3,0x5B,0x5A,0x5A,0xA3,0xF5,0xAC,0xA3,0xAC,0xAB,0xAC,0xAC,0xF4,0xAC,0xEC,0xF5,0xF5,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xEC,0xAC,0xAC,0xF5,0xAB,0x5B,0x63,0xAC,0xF5,0xA3,0xA3,0xF5,0xF5,0xF5,0xF6,0xFF,0xFE,0xFE,0xAB,0x5A,0x5A,0x5A,0x5A,0x5B,0xA3,0xA4,0xAC,0xED,0xF5,0xF5,0xF6,0xF5,0xEC,0xA3,0x9B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5B,0x5C,0x5C,0x64,0x64,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5C,0x5C},
    {0x66,0x66,0x66,0x66,0x6E,0x6E,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0x65,0x65,0x65,0x65,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0x65,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x12,0x12,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0x5A,0x63,0x5A,0x52,0x52,0x5A,0xA3,0xF5,0xA3,0x52,0x52,0x52,0x52,0x5A,0xF4,0xA3,0xA3,0xA4,0x5A,0x5A,0xAC,0xF5,0xF5,0xF5,0xAC,0xAB,0xAC,0xF5,0xA3,0xA3,0xA3,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xAB,0xEC,0xA3,0x5A,0x5A,0x5A,0x5B,0xA3,0xF5,0xF4,0xAC,0xA3,0xA3,0xAC,0xF5,0xEC,0xF5,0xF5,0xF5,0xF5,0xF4,0xAC,0xAC,0xAC,0xAC,0xEC,0xAC,0xAC,0x9B,0xAC,0xF5,0xEC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF6,0xFE,0xF3,0x9A,0x5A,0x52,0x52,0x52,0x5A,0x5A,0x5A,0x5A,0x5B,0xA3,0xA4,0xAC,0x9A,0x52,0x5B,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x64,0x64,0x5C,0x64,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0x64,0x64,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B},
    {0x6E,0x6E,0x66,0x66,0x66,0x6E,0x65,0x5D,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0x65,0x65,0x64,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x5A,0x5A,0x52,0x52,0x52,0x52,0x5A,0xA3,0x5A,0x52,0x52,0x52,0x52,0x5A,0xF5,0x52,0x52,0x52,0x52,0x5A,0xA3,0xF5,0xAC,0xF5,0xA3,0x5A,0x5A,0xAC,0xAC,0xAC,0xAB,0xAC,0xA3,0xAC,0xAB,0xA3,0xA3,0xAB,0xAC,0xA3,0xA3,0x51,0xAC,0xF5,0xF5,0xF4,0xA3,0xA3,0xA3,0xA3,0xAC,0xF5,0xAC,0xF5,0xF4,0xF5,0xF5,0xAC,0xAC,0xAC,0xAC,0xAC,0xEC,0xAC,0xAC,0x52,0xA4,0xAB,0xEC,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xEC,0x9A,0x5A,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0x5B,0xA4,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x5C,0x64,0x64,0x65,0xA5,0xA5,0xA5,0x64,0x64,0x65,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x6E,0x6E,0x66,0x66,0x65,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x65,0xA5,0xA5,0xAD,0xAD,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0x65,0xA5,0xAD,0xAE,0xAE,0x65,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x12,0x11,0x12,0x11,0x11,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0xA3,0xA3,0x52,0x52,0x52,0x52,0x52,0x5A,0xA3,0x52,0x52,0x52,0x52,0x52,0xAC,0xFD,0x5A,0x5A,0x52,0x52,0x5A,0x5A,0xEC,0xA3,0xAD,0x5A,0x5A,0xAC,0xF5,0xF5,0xF4,0xA3,0x5A,0xA3,0xA3,0xA3,0xA3,0xF5,0xF5,0xAC,0xA3,0x5A,0x5A,0x5A,0xA3,0xAC,0xEC,0xEC,0xF5,0xF5,0xF5,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xEC,0xA3,0x52,0x63,0xAC,0xA4,0xAC,0xA3,0x5A,0x9B,0xA3,0xAC,0xAC,0xF5,0xEC,0xB4,0xF5,0xF5,0xF5,0xF4,0xF5,0xA3,0x5A,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0xA4,0x5B,0x52,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x64,0xA5,0xA4,0x64,0x64,0x64,0x65,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0xA4,0xA4,0xA4,0xA4,0x64,0x5C,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x66,0x66,0x6E,0x6E,0x66,0x65,0x5C,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0x65,0xA5,0xAD,0xAD,0x65,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x52,0x53,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x0A,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x12,0x11,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0xAB,0xEC,0x52,0x52,0x52,0x52,0x52,0x5A,0x5A,0x5A,0x5B,0x5A,0x5A,0xA3,0xF5,0xF4,0xA3,0xA4,0x5A,0x5A,0xAC,0xF5,0xF5,0xAB,0xA3,0xAB,0xB4,0xF5,0xAC,0xAC,0xA3,0xAC,0xF5,0xAC,0xF5,0xF5,0xF4,0xA3,0xA3,0xAC,0xAC,0xAC,0xAC,0xAC,0xA3,0x52,0xAC,0xF4,0xAD,0xF5,0x9A,0x5A,0x5B,0x5A,0x5B,0x5A,0x5A,0x5A,0xB5,0xF5,0xF5,0xF4,0xF4,0xA3,0x5A,0x5A,0x5B,0x5A,0x5A,0x52,0x5B,0x64,0x5A,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0xA5,0xA4,0x64,0xA5,0xA5,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5C,0xA4,0xA4,0xA4,0xA4,0xA4,0x64,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xA5,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x64,0x5C,0x5B,0x53,0x53,0x12,0x12,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x51,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0x5A,0x52,0x52,0x52,0x52,0x5A,0xAC,0x5B,0x52,0x52,0x52,0x5A,0x52,0xF5,0xA2,0xA4,0xAC,0x52,0x52,0x5A,0xF5,0xAC,0x5A,0x5A,0x5A,0x5A,0xF5,0xF5,0xF5,0xAC,0xF4,0xF5,0xF5,0xF5,0xF5,0xF5,0xA3,0x52,0x5A,0x9A,0xA3,0xA3,0xAC,0x9A,0x52,0xAC,0xA3,0xAD,0xEC,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5B,0xAD,0xAC,0xF5,0xF4,0xA3,0x5A,0x5A,0x5A,0x5A,0x5A,0x5B,0x5B,0x5A,0xAD,0xF5,0xA3,0x52,0x52,0x52,0x52,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0xA5,0xA5,0xA4,0x64,0x64,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x64,0xA4,0xA4,0xA4,0xA4,0xA4,0x5C,0x5B,0x53,0x53,0x53,0x53,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0x65,0x65,0x64,0x64,0xA5,0x65,0x65,0x64,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x11,0x12,0x12,0x11,0x51,0x52,0x52,0x51,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0xAC,0x5A,0x52,0x52,0x52,0x52,0x5A,0x5A,0x52,0xAD,0xA4,0x52,0x5A,0xA3,0xF5,0xA3,0xA3,0xAC,0xF4,0xF5,0xF5,0xF5,0xF4,0xEC,0x5B,0x52,0x52,0x52,0x51,0x51,0x52,0x5B,0xB5,0xA3,0x5B,0x9A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5A,0x5B,0xAD,0xF5,0xA4,0xF5,0xF4,0x9A,0x5A,0x5A,0x52,0x52,0x52,0x52,0x5B,0x5B,0x5B,0xF5,0x9A,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x64,0x64,0x5C,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA4,0xA4,0x64,0x5B,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0xA5,0xA5,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAD,0xAE,0xAE,0xAE,0xA5,0xA5,0x65,0x64,0x64,0xA5,0x65,0x64,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x12,0x11,0x11,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x11,0x12,0x11,0x12,0x52,0x52,0x52,0x52,0x52,0x5B,0x52,0x52,0x52,0x5A,0x52,0x5A,0x52,0x52,0x52,0x52,0x52,0x5B,0xA3,0x52,0x52,0x52,0x51,0x52,0x5A,0xAC,0x52,0x5A,0x52,0x52,0x52,0x5A,0xF5,0xA3,0xAD,0xA3,0x9A,0xA3,0xF5,0xF5,0xF4,0xEC,0xAC,0xF4,0xB5,0xAC,0x5A,0x52,0x52,0xA4,0xF5,0xF5,0xA3,0xA3,0x5B,0x52,0x52,0x52,0x52,0x5A,0x52,0xA3,0xA3,0xAC,0xF5,0xEC,0x5A,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0xB5,0x9A,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x64,0x64,0x65,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0xA4,0xA4,0x5B,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x64,0x64,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x12,0x12,0x11,0x12,0x51,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x51,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0xF4,0x5A,0xA4,0x5A,0x5A,0x5A,0xF4,0xF5,0xA2,0xA3,0x5A,0x52,0xA3,0xF4,0xAC,0x5A,0xA4,0xAC,0xF5,0xF4,0xA3,0xAC,0xF5,0xF5,0xAD,0xAC,0xA3,0x5A,0x52,0x63,0x5B,0xAC,0xF5,0xF4,0x5A,0x5B,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0xAC,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x65,0x64,0x64,0x65,0x64,0x65,0x65,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x6E,0x65,0x5D,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x12,0x12,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x12,0x51,0x51,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x51,0x52,0x52,0x52,0x52,0x51,0x52,0x51,0x5B,0xF4,0x5A,0x52,0x52,0x52,0x5A,0xB5,0xAB,0x5B,0xF5,0x5A,0x52,0x52,0x5A,0xFD,0xAC,0xAB,0x9A,0xAC,0xF4,0xAC,0xB5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xA4,0xB5,0xF5,0xF5,0xF5,0xF5,0x5A,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0xAC,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x5C,0x5C,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x64,0x65,0x64,0x64,0x65,0x65,0x65,0x65,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x53,0x53,0x53,0x53,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0xAD,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x53,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x12,0x12,0x11,0x12,0x12,0x12,0x52,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x11,0x11,0x51,0x51,0x52,0x52,0x52,0x52,0x52,0x52,0x5A,0x52,0x52,0x52,0x51,0x52,0x51,0xA3,0xA3,0x52,0x52,0x51,0x52,0x5A,0xF4,0x5A,0x52,0x52,0x52,0x52,0x51,0x5A,0xA3,0xA3,0xB5,0x5A,0x5A,0xF5,0xF5,0xF5,0xF5,0xF5,0xF4,0xF5,0xF5,0xF5,0xF5,0xAC,0xF5,0xF5,0xF5,0xAC,0xAC,0x5A,0x5B,0x52,0x52,0x52,0x52,0x5B,0x5B,0xAD,0xA3,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x5B,0x5B,0x5C,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x64,0x65,0x65,0x65,0xA5,0x65,0xA5,0x65,0x65,0x65,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B},
    {0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xA5,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x12,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x12,0x12,0x12,0x12,0x12,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x12,0x12,0x11,0x12,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x52,0x52,0x52,0x52,0x5B,0x5B,0x52,0x52,0x52,0x51,0x51,0x51,0x52,0x51,0x52,0x52,0x5A,0xA2,0x52,0x52,0x51,0x51,0x52,0x52,0x5A,0x5A,0x5A,0xAC,0x51,0x5A,0xA3,0xF5,0xF5,0xA3,0xAC,0x9A,0x5A,0xAC,0xFD,0xF5,0xEC,0xB4,0xF5,0xF5,0xF5,0xF5,0xA3,0x5A,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0xA4,0x9A,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x64,0x5C,0x5C,0x64,0x64,0x64,0x64,0x5C,0x64,0xA5,0xA5,0xA5,0x65,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x6E,0x66,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0xA5,0x65,0xA5,0xA5,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0x65,0x65,0x65,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x52,0x12,0x52,0x12,0x12,0x12,0x12,0x12,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x09,0x11,0x11,0x11,0x11,0x11,0x51,0x51,0x11,0x11,0xA4,0x52,0x52,0x5A,0x52,0x51,0x52,0x52,0x63,0x51,0x51,0x52,0x51,0x51,0x51,0x52,0x5A,0xA3,0x52,0x52,0x52,0x52,0x5A,0xB5,0xF4,0x9A,0xF5,0xA2,0x52,0x5A,0xAC,0xF5,0xEC,0xAB,0xAB,0xF4,0xF5,0xF5,0xEC,0xA3,0x5A,0x5A,0x5B,0x5B,0xB5,0xA3,0x5B,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x64,0x5C,0x5C,0x64,0x65,0xA5,0xA5,0x64,0x65,0xAD,0xAD,0xA5,0x65,0x64,0x64,0x65,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x6E,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0x65,0x65,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0x65,0x64,0x5C,0x64,0x64,0x64,0x64,0x64,0xA4,0xA5,0x64,0x5C,0x5B,0x5C,0x64,0x64,0x5C,0x5B,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x09,0x11,0x11,0x11,0x11,0x09,0x11,0x11,0x11,0x11,0x51,0x51,0x52,0x52,0x52,0x52,0x52,0x5A,0x52,0x52,0x52,0x51,0x51,0x51,0x51,0x52,0x52,0x52,0x52,0x52,0x5A,0x5B,0xFD,0xA3,0x52,0x52,0x52,0x52,0x52,0x5A,0xA3,0xA3,0xAD,0xA3,0x5A,0xA4,0xF5,0xF5,0xEC,0x5A,0x5B,0x63,0x63,0xAC,0xA3,0x5B,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x65,0x65,0xA5,0x65,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x53,0x5B,0x5C,0x5C,0x5C,0x5C},
    {0xAE,0x6E,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x64,0x64,0x64,0x64,0x64,0x64,0xA4,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5C,0x64,0xA4,0x64,0x5C,0x5B,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x11,0x09,0x11,0x11,0x11,0x09,0x09,0x09,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x09,0x09,0x09,0x09,0x11,0x51,0x51,0x52,0x52,0x52,0x52,0x51,0x51,0x51,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0xF5,0x99,0x52,0x52,0x52,0x52,0x52,0x5A,0x5A,0x5A,0xA4,0x9A,0x5A,0x52,0xB5,0xF5,0xEC,0xA3,0x5A,0x5A,0xAC,0xAC,0xA3,0x5B,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0xA4,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x65,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x5C,0x5C},
    {0x6E,0x6E,0x66,0x6E,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xA5,0x64,0x5C,0xA4,0xAD,0xA5,0x64,0x64,0xA5,0xA5,0x64,0x64,0x64,0x5C,0x64,0xA4,0xA4,0xA4,0x64,0x64,0x64,0x5B,0x5B,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x11,0x09,0x11,0x11,0x09,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x11,0x12,0x52,0x52,0x51,0x51,0x52,0xA4,0x52,0x52,0x52,0x52,0xA3,0xA3,0x52,0x52,0x52,0x51,0x52,0x52,0xA3,0x5A,0x52,0x52,0x52,0x52,0x52,0xAC,0xF4,0x9A,0xB5,0xEC,0x52,0x52,0xA3,0xA4,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x64,0x65,0xA5,0x64,0x5C,0x64,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x52,0x52,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x53,0x53,0x5C},
    {0x65,0x65,0x65,0x6E,0x6E,0x66,0x66,0x65,0x65,0x65,0x65,0x64,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0x65,0x64,0xA4,0xA5,0xA5,0x65,0xA5,0xA5,0xA5,0x65,0xAD,0x65,0x64,0x5C,0xA4,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x12,0x11,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x11,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x11,0x51,0x5B,0x52,0x52,0x52,0x5B,0x5A,0x52,0x52,0x52,0x51,0x52,0x52,0x52,0x5A,0x52,0x52,0x52,0x51,0x52,0x52,0xAD,0xEB,0x52,0x5B,0x9B,0x52,0x52,0x52,0xA4,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0xA5,0xA5,0xAD,0xA5,0xA5,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B},
    {0x65,0x65,0x65,0x65,0x6E,0xAE,0xAE,0x6E,0x65,0x65,0x65,0x64,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x64,0x65,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0x64,0x64,0xA5,0xAD,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x64,0xA4,0xA4,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x09,0x09,0x09,0x09,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x52,0x51,0x52,0x52,0x52,0x51,0x52,0x52,0x52,0x52,0x51,0x52,0x52,0x51,0x51,0x52,0xAC,0x9A,0x52,0x52,0x52,0x52,0x52,0x52,0xA4,0x5A,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x5C,0x64,0x64,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x65,0x6E,0xAE,0xAE,0xAE,0xAE,0x6E,0x65,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0xA5,0xA5,0xAD,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0x64,0xA5,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x64,0xA4,0xA4,0xA5,0xA5,0xA5,0xAD,0xAD,0x65,0x64,0x64,0xA4,0xA5,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5C,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x12,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x09,0x11,0x09,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x11,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x51,0x51,0x51,0x5A,0x5A,0x51,0x52,0x52,0x52,0x52,0x52,0x52,0xA4,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0xA5,0x65,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x65,0x65,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0x65,0xA4,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x64,0xA4,0xA4,0xA5,0xAD,0xAD,0xAD,0xA5,0x64,0xA4,0xA5,0xA5,0xA4,0xA4,0x64,0x5B,0x5B,0x64,0x64,0x64,0xA4,0xA4,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x12,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x09,0x09,0x11,0x51,0x52,0x52,0x52,0x52,0x52,0x51,0x5A,0x5A,0x51,0x52,0x52,0x52,0x52,0x52,0x52,0xA4,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x64,0xA4,0xA4,0xA4,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x66,0x65,0x65,0x65,0xAE,0xAE,0xAE,0x66,0x65,0x5C,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0x65,0x64,0xA4,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x64,0x64,0xA4,0xAD,0xA4,0xAD,0xAD,0xA5,0x64,0xA4,0xA5,0xA5,0xA4,0x64,0x5C,0x64,0x64,0x64,0x64,0xA4,0xA4,0xA5,0x64,0x64,0x64,0x64,0x64,0x5B,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x09,0x11,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x11,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x11,0x52,0x52,0x5B,0x5B,0x52,0x53,0x53,0x53,0x53,0x52,0x53,0x52,0x52,0x53,0x5B,0x5C,0x5C,0x64,0xA5,0xA4,0xA4,0x64,0xA5,0xA4,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x52,0x52,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x6E,0x6E,0x6E,0x65,0x65,0x6E,0xAE,0x66,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAE,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x64,0xA5,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0x64,0xA4,0xA5,0x64,0x64,0x64,0x64,0xA4,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0xA4,0xA5,0x64,0x64,0x5C,0x64,0x64,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x12,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x11,0x11,0x11,0x09,0x11,0x11,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA4,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x65,0x66,0xAE,0xAE,0x6E,0x65,0x65,0x66,0x65,0x65,0x64,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0xA5,0xA4,0xAD,0xAD,0xAE,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x12,0x11,0x11,0x0A,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0xA5,0xA5,0xA5,0xA4,0x64,0x64,0x64,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x66,0x65,0x65,0x65,0xAE,0xAE,0xAE,0xAE,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0xA5,0xAD,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA4,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0x64,0xA4,0xA5,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x53,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x0A,0x09,0x09,0x09,0x11,0x11,0x11,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x12,0x12,0x52,0x52,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x53,0x53,0x53,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x6E,0x66,0x65,0x65,0x65,0x65,0xAE,0xAE,0xAE,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0xA5,0xAD,0xAE,0xB6,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA4,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x64,0x64,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA4,0x64,0x64,0xA4,0x64,0xA5,0xA5,0x64,0x64,0x64,0xA4,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x52,0x12,0x09,0x11,0x12,0x12,0x12,0x11,0x09,0x09,0x09,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x11,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA4,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x66,0x65,0x66,0x65,0x65,0x65,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0xAD,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xA5,0xA4,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA4,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0x64,0xA5,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x5C,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x5B,0x5B,0x5B,0x52,0x5B,0x5B,0x52,0x52,0x53,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x12,0x11,0x09,0x11,0x11,0x11,0x09,0x09,0x11,0x09,0x09,0x09,0x11,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x65,0xA5,0xA4,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x65,0x65,0x6E,0x6E,0x66,0x65,0x65,0x65,0x65,0x65,0xAE,0x65,0x65,0x5C,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0x64,0x64,0x65,0xAD,0xA5,0xAD,0xA5,0x65,0x64,0x64,0x64,0x64,0x64,0x64,0xA4,0x64,0xA5,0xAD,0xA5,0xAD,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x5C,0x5C,0x5B,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x0A,0x0A,0x09,0x0A,0x0A,0x0A,0x0A,0x0A,0x09,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x64,0x64,0x64,0x64,0xA5,0x64,0x5C,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0xA5,0xA5,0x64,0x64,0x65,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x65,0x65,0x65,0x66,0x6E,0x6E,0x6E,0x66,0x65,0x65,0x65,0x6E,0xAE,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x65,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xA5,0xAD,0xAE,0xAE,0xA5,0xA5,0xAD,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0x65,0x64,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0x65,0x64,0x64,0x64,0x64,0x64,0xA5,0x64,0xA5,0x64,0xA4,0xA5,0xAD,0x64,0x64,0x64,0xA5,0x64,0x64,0x65,0x64,0x64,0x5C,0x5B,0x5C,0x5B,0x5C,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x0A,0x12,0x0A,0x0A,0x09,0x0A,0x09,0x0A,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5C,0x5B,0x5B,0x64,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x52,0x52,0x53,0x52,0x53,0x52,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x66,0x6E,0x6E,0x66,0x65,0x65,0x6E,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x64,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xA5,0x65,0xA5,0x64,0x64,0x64,0x64,0xA5,0xAD,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0xA4,0xA5,0xAD,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x64,0x5C,0x5B,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x0A,0x0A,0x0A,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0xA4,0x64,0x64,0x64,0x64,0xA5,0xA4,0x64,0x64,0x64,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x53,0x52,0x52,0x52,0x53,0x53,0x53,0x53,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x66,0x6E,0xAE,0x66,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xA5,0x65,0xA5,0x65,0x65,0x64,0x64,0x64,0x64,0xA5,0xAD,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0xA4,0x64,0xA4,0xA5,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5B,0x5C,0x64,0x64,0x5B,0x5B,0x5C,0x64,0x64,0x5B,0x64,0x5C,0x5B,0x5B,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x52,0x52,0x53,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x5C,0x64,0x64,0x5C,0x64,0xA4,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0x65,0x64,0x5C,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C},
    {0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x66,0x6E,0x6E,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xA5,0xAD,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0x65,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0x65,0x65,0x64,0x64,0x64,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x64,0x64,0x5C,0x5B,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x12,0x12,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x65,0xA5,0x64,0x64,0x5C,0x64,0x65,0xA5,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x53,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C},
    {0x66,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x6E,0x6E,0x6E,0x66,0x65,0x65,0x64,0x5C,0x5C,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0x65,0xA5,0xA5,0xA5,0xA5,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x64,0x64,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x65,0x65,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x65,0xA5,0xA5,0x64,0x64,0x5C,0x5B,0x5B,0x53,0x5B,0x53,0x53,0x53,0x5B,0x5B,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C,0x5C},
    {0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x65,0x66,0x65,0x65,0x65,0x6E,0x6E,0x6E,0x6E,0x65,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB7,0xB7,0xB7,0xB7,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0x65,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0xA4,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x64,0xA5,0x64,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0x64,0x64,0x64,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x64,0x5B,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x64,0x64,0xA5,0xA5,0x64,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x53,0x5B,0x53,0x53,0x53,0x53,0x5B,0x52,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5C,0x5C},
    {0x66,0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x6E,0x6E,0x65,0x65,0x5C,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x64,0x64,0x64,0x64,0xA5,0xAD,0xA5,0xA5,0x64,0x64,0x64,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0xA4,0xA4,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5C,0x5B,0x5B,0x5C,0x64,0x5C,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x12,0x52,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x5B,0x5B,0x5B,0x9C,0xA4,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x53,0x53,0x53,0x53,0x53,0x5B},
    {0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x6E,0x6E,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xB6,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xA5,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0x64,0x64,0x64,0xA5,0xA5,0xAD,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0x64,0x64,0x64,0x64,0x5C,0x5C,0x64,0x64,0xA4,0xA4,0x64,0xA4,0x64,0xA4,0xA4,0x64,0x64,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x64,0x64,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x5B,0x5B,0x5B,0xA4,0xA4,0xA4,0xA4,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x52,0x53,0x53,0x53,0x53,0x53,0x53},
    {0x66,0x65,0x66,0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x66,0x65,0x65,0x65,0x6E,0x65,0x65,0x5C,0x5C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAD,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0x65,0xA4,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0x65,0x64,0x5C,0x64,0xAD,0xAD,0xA5,0x65,0x64,0x64,0x64,0x64,0x5C,0x64,0x64,0xA5,0xA5,0x65,0x64,0x64,0x64,0x64,0x64,0x5C,0x64,0x64,0xA4,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x5C,0x5C,0x64,0x64,0x5C,0x64,0x65,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0x5B,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x52,0x53,0x53,0x53,0x53,0x53,0x53},
    {0x66,0x66,0x65,0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5B,0x53,0x53,0x5B,0x53,0x53,0x53,0x5B,0x5B,0x5C,0x64,0x65,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x64,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x64,0x5C,0x64,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0xA5,0x64,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x64,0xA4,0x64,0x64,0xA4,0x64,0x64,0x64,0xA4,0x64,0xA5,0xA5,0x64,0x64,0xA5,0x64,0x5C,0x5C,0x64,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5B,0x5C,0x5C,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x65,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0xA4,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0xA4,0xA4,0xA4,0xAD,0xA4,0xA4,0xA4,0x9B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53},
    {0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0x65,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x64,0xA5,0x64,0x64,0x64,0x64,0xA5,0xA4,0xA5,0xA4,0x64,0x64,0x64,0xA5,0x64,0x5C,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0x65,0xA5,0x64,0x64,0x64,0x5C,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0xA4,0xA4,0xA4,0xAD,0xAD,0xA5,0xA4,0xA4,0xA4,0x9B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53},
    {0x65,0x66,0x66,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x65,0x65,0x66,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5B,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB7,0xB6,0xAE,0xAE,0xAE,0xB6,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAE,0xAE,0xAD,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0x65,0xAD,0xAD,0xA5,0x65,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x64,0x64,0xA5,0x64,0x64,0x64,0x64,0x65,0x65,0xA5,0x64,0x64,0xA4,0x5C,0x5C,0x64,0xA5,0xA4,0x64,0x64,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x64,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x65,0x65,0x64,0x64,0x64,0xA5,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x5B,0x5B,0xA4,0xA4,0xA4,0xA5,0xAD,0xA5,0xA4,0xA4,0xA4,0x9C,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53},
    {0x65,0x65,0x65,0x66,0x66,0x66,0x65,0x66,0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xAD,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xA5,0xAD,0x65,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x64,0x64,0x64,0xA4,0xA5,0xAD,0xA5,0x65,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0x64,0x5B,0x5C,0x64,0x64,0x5C,0x5C,0x64,0xA5,0xA5,0xA4,0xA4,0x64,0x64,0x64,0x64,0xA5,0x64,0x64,0x64,0xA4,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5C,0x64,0x64,0x64,0x64,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x52,0x52,0x53,0x5B,0x5B,0xA4,0xA4,0xA5,0xAD,0xAD,0xA5,0xA4,0xA4,0xA4,0x9C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53},
    {0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x66,0x66,0x66,0x65,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAE,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0x65,0xA5,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xA5,0x64,0x64,0x64,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x64,0xA5,0xA5,0x64,0x64,0xA5,0x64,0x5B,0x64,0x64,0xA5,0x64,0x5C,0x64,0xA5,0xA5,0x64,0xA5,0x64,0x64,0x64,0x64,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5B,0x5C,0x64,0x64,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x0A,0x12,0x52,0x52,0x5B,0x5B,0xA4,0xA4,0xA4,0xAD,0xAD,0xAD,0xA5,0xA4,0xA4,0x9C,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53},
    {0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x5B,0x5C,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAD,0xAD,0xAD,0x65,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xB6,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xAD,0xAD,0x65,0xA5,0xAD,0xA5,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0xA4,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0xA4,0xA5,0xA5,0x64,0x64,0xA5,0xA5,0x64,0xA5,0xA5,0x64,0x64,0x65,0x64,0xA5,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x64,0x64,0x5C,0x64,0x64,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x5B,0x5B,0xA4,0xA4,0xA4,0xAD,0xAD,0xA5,0xA4,0xA4,0xA4,0x5B,0x5B,0x5B,0x53,0x52,0x53},
    {0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA4,0xA5,0xAD,0xAE,0xB6,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xAE,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xA5,0xA5,0x65,0x64,0x64,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x65,0x64,0x64,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0x64,0x64,0x5C,0x64,0xA4,0xA5,0xA5,0x65,0xA5,0xA4,0x64,0x64,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5B,0x5B,0x64,0x64,0x5C,0x64,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x5B,0x5B,0xA4,0xA4,0xA4,0xA5,0xAD,0xA5,0xA4,0xA4,0xA4,0x9C,0x5B,0x5B,0x53,0x53},
    {0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x65,0x5D,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x65,0xA5,0xAD,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xB6,0xAE,0xAD,0xAD,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xAE,0xA4,0x5C,0x5C,0xA4,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xAD,0xAD,0xA5,0xA5,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0x64,0xAD,0xAD,0xA5,0x65,0xAD,0xAD,0xA5,0x65,0xA5,0xAD,0xAD,0x65,0x65,0x65,0xA5,0x64,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0xA5,0xA5,0x64,0x64,0x5C,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0xA5,0x64,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5B,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x64,0x64,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x12,0x52,0x53,0x5B,0x5B,0xA4,0xA4,0xA4,0xA5,0xA5,0xA4,0xA4,0xA4,0xA4,0x5B,0x5B,0x5B},
    {0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAD,0xAE,0xAD,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x64,0x64,0x64,0xA4,0xAD,0xAE,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAE,0xAD,0xA5,0xA5,0x65,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0xA5,0xA5,0xAD,0xA5,0x65,0xA5,0x64,0x64,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0xA5,0xA5,0xA5,0x65,0xA4,0x64,0x65,0x64,0x5C,0x64,0xA4,0xA5,0x64,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0xA5,0x64,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5C,0x5C,0x64,0x64,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x12,0x52,0x52,0x5B,0x5B,0x5B,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0x9C,0x5B},
    {0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0xA5,0xAD,0xAE,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0xA4,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xA5,0x64,0x64,0xA5,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xA5,0xA5,0x64,0x64,0x64,0x5C,0x5C,0x64,0xAD,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x5C,0x64,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0x64,0xA5,0x64,0x64,0xA5,0xA5,0xA5,0x64,0xA5,0xA5,0x64,0x64,0x5C,0x5C,0x5B,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x5B,0x5B,0x5C,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0x9C},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAE,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0x65,0x65,0xAD,0xA5,0x65,0x64,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0x64,0x64,0x65,0x65,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0x64,0xA5,0x64,0x64,0x64,0x64,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x5C,0x5C,0x64,0x64,0x5C,0x64,0x5C,0x64,0x64,0x64,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x52,0x52,0x52,0x5B,0x5B,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x6E,0x66,0x66,0x65,0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x5B,0x5C,0x64,0x65,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0x65,0xA5,0xAD,0xAE,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0x65,0xA5,0xA4,0xA4,0xAD,0xAD,0xAD,0xA5,0x64,0x64,0x65,0xAD,0xAD,0xA5,0x64,0x64,0xA5,0xA5,0xA5,0x64,0x64,0xA4,0x64,0x64,0x64,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x52,0x52,0x53,0x5B,0x5B,0xA4,0xA4,0xA4,0xA4,0xA4},
    {0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x66,0x65,0x66,0x66,0x66,0x66,0x66,0x65,0x5D,0x5C,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x65,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xA5,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x64,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xA5,0xAD,0xAD,0x65,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0x65,0x64,0xA5,0xAD,0xAD,0xA5,0x64,0x64,0xA5,0xA4,0xA5,0x65,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x5C,0xA4,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0x64,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x65,0xA5,0x65,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x12,0x12,0x12,0x12,0x0A,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x5B,0x5B,0x5B,0xA4,0xA4,0xA4},
    {0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x65,0x5D,0x5C,0x65,0x64,0x64,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xA5,0xA5,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xB6,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0x65,0x65,0xA5,0xAD,0xAE,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0x65,0x64,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0xA5,0xA4,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xA4,0xA5,0xA5,0xA5,0xA4,0xA4,0xA5,0xA5,0x64,0xA5,0xA4,0x64,0x5C,0x5C,0x5C,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x12,0x12,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x5B,0x5B,0x5B,0xA4},
    {0x65,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x6E,0x66,0x65,0x5D,0x65,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xA5,0x65,0x64,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0x65,0x65,0xA5,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0xAD,0xAD,0xAD,0xA5,0xAD,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0xA4,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x52,0x12,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x52,0x52,0x5B,0x5B,0x5B},
    {0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x66,0x65,0x66,0x66,0x66,0x65,0x65,0x65,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xA5,0xAD,0xAD,0xAD,0xA5,0x65,0x65,0x65,0x64,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0xA5,0x64,0x64,0x64,0x64,0x64,0xA4,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x12,0x12,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x0A,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x0A,0x09,0x0A,0x09,0x09,0x0A,0x0A,0x52,0x52,0x5B},
    {0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0xA4,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xB6,0xF6,0xF6,0xF7,0xF6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAD,0xA5,0x65,0xA4,0xA5,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0xA5,0x64,0x64,0xA5,0xAD,0x65,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xA5,0xA4,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x12,0x12,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x09,0x09,0x0A,0x0A,0x0A,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0A,0x0A,0x12,0x52},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xAD,0xAD,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xAE,0xB6,0xB6,0xAE,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0x64,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0x65,0x65,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x65,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x0A,0x0A,0x0A,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0A,0x0A},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xAD,0xAD,0xB6,0xF6,0xB6,0xB6,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xB6,0xAD,0xAE,0xAE,0xAD,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA4,0xA5,0xAD,0x65,0x64,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0xA4,0xA4,0xA5,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0x64,0xA4,0xA5,0xA4,0xA4,0xA5,0x64,0x64,0x64,0xA5,0xA5,0xA5,0x65,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x09,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAD,0xAD,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAD,0xAD,0xAD,0xF6,0xF6,0xF7,0xB6,0xB6,0xF6,0xF6,0xF6,0xB6,0xAE,0xB6,0xAD,0xB6,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x5C,0x5B,0x5C,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xA4,0xA5,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA4,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0xA5,0xA4,0xA5,0xA5,0x64,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x5C,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAD,0xB6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA4,0x5C,0x5C,0x5C,0xA5,0xAD,0xAD,0xAD,0xA5,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0x64,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA4,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0x64,0x64,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0xA4,0x64,0xA5,0x64,0xA5,0xA5,0x64,0xA5,0xA5,0xA5,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x13,0x53,0x53,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x09,0x0A,0x0A,0x0A,0x0A,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
    {0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x66,0x66,0x66,0x65,0x65,0x65,0x65,0x65,0x64,0x64,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF7,0xFF,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAE,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0x65,0x64,0x64,0xA5,0xAD,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0x64,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0xA5,0xA5,0xA5,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x5B,0x5B,0x53,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x09,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09,0x09},
    {0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x64,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xB6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0x64,0xA4,0xAD,0xAD,0xAD,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0xAD,0xAD,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0x64,0xA4,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0x64,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x53,0x13,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x09,0x09,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x52,0x52,0x52,0x52,0x52,0x52,0x12,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09},
    {0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x66,0x65,0x65,0x5D,0x5D,0x65,0x64,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB7,0xB6,0xAE,0xB6,0xB6,0xB6,0xB6,0xF6,0xF7,0xF7,0xF7,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xAE,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA4,0xA4,0xAD,0xAE,0xAD,0xA5,0xA5,0xAD,0xA5,0xA5,0xA5,0xA5,0xA4,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0xA4,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0x64,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x52,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x0A,0x0A,0x0A,0x09,0x09,0x09},
    {0x65,0x65,0x5D,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x65,0x64,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xB6,0xB6,0xB6,0xF6,0xF6,0xF7,0xFF,0xFF,0xF7,0xF7,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xA5,0xA5,0xA4,0xA4,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x52,0x52,0x52,0x52,0x12,0x12,0x12,0x12,0x12,0x12,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x12,0x52,0x52,0x52,0x52,0x52,0x12,0x12,0x0A,0x0A,0x09,0x09},
    {0x65,0x65,0x65,0x5D,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x64,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x64,0x64,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xB6,0xB6,0xF6,0xF7,0xFF,0xFF,0xFF,0xFF,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xF6,0xAE,0xAE,0xAE,0xAD,0xB6,0xAE,0xB6,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xA5,0xA4,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x52,0x12,0x12,0x52,0x12,0x12,0x12,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x12,0x12,0x12,0x52,0x52,0x12,0x12,0x0A,0x0A,0x0A},
    {0x5C,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF7,0xFF,0xFF,0xFF,0xFF,0xF7,0xF6,0xF6,0xF7,0xFF,0xFF,0xF7,0xF6,0xF6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xB6,0xB6,0xB6,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xA5,0xA5,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA4,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x12,0x52,0x52,0x12,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x12,0x52,0x12,0x52,0x52,0x12,0x12,0x0A},
    {0x5C,0x5C,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF7,0xB7,0xB6,0xF7,0xF6,0xF7,0xF7,0xF6,0xF7,0xFF,0xFF,0xFF,0xFF,0xF7,0xF6,0xF7,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xB6,0xAE,0xAE,0xAD,0xAD,0xAE,0xB6,0xAE,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xAD,0xB6,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA4,0xA4,0xA4,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x52,0x12,0x12,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x12,0x13,0x13,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x09,0x09,0x0A,0x0A,0x0A,0x12,0x12,0x52,0x12,0x52,0x12},
    {0x5C,0x5C,0x5C,0x5D,0x65,0x65,0x65,0x65,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF7,0xF7,0xB6,0xF6,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xFF,0xFF,0xFF,0xF7,0xF6,0xF6,0xF6,0xFF,0xFF,0xF7,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xB6,0xAE,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0xA4,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x52,0x12,0x12,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x0A,0x0A,0x0A,0x12,0x12,0x52,0x52},
    {0x13,0x53,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0xA5,0xA5,0xA5,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF7,0xF7,0xF7,0xF7,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAE,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA4,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x52,0x12,0x12,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x12,0x0A,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x09,0x0A,0x0A,0x09,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0A,0x0A,0x12,0x52},
    {0x13,0x13,0x53,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB7,0xF7,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF7,0xF7,0xFF,0xFF,0xFF,0xFF,0xF7,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAD,0xAE,0xB6,0xB6,0xB6,0xAE,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xF6,0xB6,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAE,0xB6,0xB6,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA4,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x12,0x12,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x12,0x0A,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0A,0x0A,0x12},
    {0x0A,0x13,0x13,0x53,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB7,0xB7,0xB6,0xF7,0xF7,0xF7,0xF7,0xF7,0xFF,0xFF,0xF7,0xF7,0xF7,0xFF,0xFF,0xFF,0xFF,0xF7,0xF6,0xF7,0xF7,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAD,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA4,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x12,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0A},
    {0x09,0x0A,0x12,0x13,0x13,0x13,0x5C,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB7,0xB7,0xB6,0xB6,0xF7,0xFF,0xFF,0xF7,0xF7,0xFF,0xFF,0xFF,0xF7,0xF7,0xFF,0xFF,0xFF,0xFF,0xF7,0xF6,0xFF,0xFF,0xF7,0xF6,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xB6,0xAE,0xAE,0xF6,0xF6,0xFF,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xAE,0xB6,0xF6,0xB6,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xAE,0xB6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0xA4,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x13,0x13,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x13,0x13,0x12,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
    {0x09,0x09,0x0A,0x12,0x13,0x13,0x13,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xF7,0xF7,0xFF,0xFF,0xF7,0xF7,0xFF,0xFF,0xFF,0xF7,0xF7,0xF7,0xF7,0xFF,0xFF,0xF7,0xF7,0xF7,0xFF,0xF7,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0x64,0x64,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x5B,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x13,0x13,0x12,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
    {0x09,0x09,0x09,0x09,0x0A,0x12,0x13,0x13,0x5C,0x5C,0x5C,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0xA4,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF7,0xF7,0xFF,0xFF,0xF7,0xFF,0xF7,0xFF,0xFF,0xF7,0xF6,0xF6,0xFF,0xFF,0xFF,0xF7,0xF7,0xF6,0xF7,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0xA4,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x53,0x5B,0x5B,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
    {0x09,0x09,0x09,0x09,0x09,0x0A,0x12,0x13,0x13,0x53,0x5C,0x5C,0x65,0x5D,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5C,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF7,0xF7,0xB7,0xF7,0xF7,0xF7,0xF7,0xF6,0xF6,0xF6,0xF6,0xFF,0xFF,0xFF,0xF6,0xF6,0xF6,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0x64,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x13,0x53,0x53,0x53,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
    {0x09,0x09,0x09,0x09,0x09,0x09,0x0A,0x12,0x13,0x53,0x53,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5D,0x65,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5D,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB7,0xB7,0xB6,0xB6,0xF6,0xF6,0xF6,0xF7,0xF7,0xFF,0xF7,0xF6,0xF6,0xF6,0xF7,0xFF,0xFF,0xFF,0xF7,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF7,0xF7,0xF7,0xF7,0xF6,0xF6,0xF6,0xF6,0xB6,0xF6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0xA4,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
    {0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0A,0x12,0x13,0x53,0x53,0x5C,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5D,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5C,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0xA5,0xA5,0xA5,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB7,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF7,0xFF,0xF7,0xF6,0xF6,0xF6,0xFF,0xFF,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF7,0xF6,0xF6,0xF6,0xF7,0xF7,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0xA4,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x12,0x0A,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
    {0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0A,0x12,0x13,0x53,0x53,0x5C,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5D,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x64,0xA5,0xA5,0xAD,0xAD,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB7,0xB7,0xB7,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF7,0xF7,0xF7,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xB6,0xB6,0xF6,0xB6,0xF6,0xF6,0xF6,0xF7,0xF7,0xF6,0xF6,0xF6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xA5,0xA5,0xA4,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x12,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
    {0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0A,0x13,0x13,0x13,0x5C,0x5C,0x5C,0x65,0x65,0x65,0x65,0x65,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5D,0x5D,0x5D,0x65,0x65,0x65,0x65,0x65,0x5D,0x5D,0x5C,0x5D,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x5D,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5C,0x5C,0x64,0x65,0xA5,0xA5,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAE,0xAE,0xAE,0xAE,0xAE,0xB6,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAE,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF7,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xB6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xB6,0xF6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xF6,0xB6,0xB6,0xB6,0xAE,0xAE,0xAE,0xAD,0xAD,0xAD,0xAD,0xAD,0xA5,0xA4,0x64,0x64,0x5C,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x5B,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x13,0x53,0x53,0x53,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x53,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0A,0x0A,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x01,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09},
};

#endif